/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeHooks;

public class LootContext {
    private final float luck;
    private final WorldServer world;
    private final LootTableManager lootTableManager;
    @Nullable
    private final Entity lootedEntity;
    @Nullable
    private final EntityPlayer player;
    @Nullable
    private final DamageSource damageSource;
    private final Set<LootTable> lootTables = Sets.newLinkedHashSet();

    public LootContext(float p_i46640_1_, WorldServer p_i46640_2_, LootTableManager p_i46640_3_, Entity p_i46640_4_, EntityPlayer p_i46640_5_, DamageSource p_i46640_6_) {
        this.luck = p_i46640_1_;
        this.world = p_i46640_2_;
        this.lootTableManager = p_i46640_3_;
        this.lootedEntity = p_i46640_4_;
        this.player = p_i46640_5_;
        this.damageSource = p_i46640_6_;
    }

    @Nullable
    public Entity getLootedEntity() {
        return this.lootedEntity;
    }

    @Nullable
    public Entity getKillerPlayer() {
        return this.player;
    }

    @Nullable
    public Entity getKiller() {
        return this.damageSource == null ? null : this.damageSource.getEntity();
    }

    public boolean addLootTable(LootTable p_addLootTable_1_) {
        return this.lootTables.add(p_addLootTable_1_);
    }

    public void removeLootTable(LootTable p_removeLootTable_1_) {
        this.lootTables.remove(p_removeLootTable_1_);
    }

    public LootTableManager getLootTableManager() {
        return this.lootTableManager;
    }

    public float getLuck() {
        return this.luck;
    }

    @Nullable
    public Entity getEntity(EntityTarget p_getEntity_1_) {
        switch (p_getEntity_1_) {
            case THIS: {
                return this.getLootedEntity();
            }
            case KILLER: {
                return this.getKiller();
            }
            case KILLER_PLAYER: {
                return this.getKillerPlayer();
            }
        }
        return null;
    }

    public WorldServer getWorld() {
        return this.world;
    }

    public int getLootingModifier() {
        return ForgeHooks.getLootingLevel(this.getLootedEntity(), this.getKiller(), this.damageSource);
    }

    public static enum EntityTarget {
        THIS("this"),
        KILLER("killer"),
        KILLER_PLAYER("killer_player");

        private final String targetType;

        private EntityTarget(String p_i46992_3_) {
            this.targetType = p_i46992_3_;
        }

        public static EntityTarget fromString(String p_fromString_0_) {
            for (EntityTarget lootcontext$entitytarget : EntityTarget.values()) {
                if (!lootcontext$entitytarget.targetType.equals(p_fromString_0_)) continue;
                return lootcontext$entitytarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + p_fromString_0_);
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter p_write_1_, EntityTarget p_write_2_) throws IOException {
                p_write_1_.value(p_write_2_.targetType);
            }

            public EntityTarget read(JsonReader p_read_1_) throws IOException {
                return EntityTarget.fromString(p_read_1_.nextString());
            }
        }
    }

    public static class Builder {
        private final WorldServer world;
        private float luck;
        private Entity lootedEntity;
        private EntityPlayer player;
        private DamageSource damageSource;

        public Builder(WorldServer p_i46993_1_) {
            this.world = p_i46993_1_;
        }

        public Builder withLuck(float p_withLuck_1_) {
            this.luck = p_withLuck_1_;
            return this;
        }

        public Builder withLootedEntity(Entity p_withLootedEntity_1_) {
            this.lootedEntity = p_withLootedEntity_1_;
            return this;
        }

        public Builder withPlayer(EntityPlayer p_withPlayer_1_) {
            this.player = p_withPlayer_1_;
            return this;
        }

        public Builder withDamageSource(DamageSource p_withDamageSource_1_) {
            this.damageSource = p_withDamageSource_1_;
            return this;
        }

        public LootContext build() {
            return new LootContext(this.luck, this.world, this.world.getLootTableManager(), this.lootedEntity, this.player, this.damageSource);
        }
    }
}

