/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.ForgeHooks;

public class LootEntryItem
extends LootEntry {
    protected final Item item;
    protected final LootFunction[] functions;

    public LootEntryItem(Item p_i11_1_, int p_i11_2_, int p_i11_3_, LootFunction[] p_i11_4_, LootCondition[] p_i11_5_, String p_i11_6_) {
        super(p_i11_2_, p_i11_3_, p_i11_5_, p_i11_6_);
        this.item = p_i11_1_;
        this.functions = p_i11_4_;
    }

    @Override
    public void addLoot(Collection<ItemStack> p_addLoot_1_, Random p_addLoot_2_, LootContext p_addLoot_3_) {
        ItemStack itemstack = new ItemStack(this.item);
        for (LootFunction lootfunction : this.functions) {
            if (!LootConditionManager.testAllConditions(lootfunction.getConditions(), p_addLoot_2_, p_addLoot_3_)) continue;
            itemstack = lootfunction.apply(itemstack, p_addLoot_2_, p_addLoot_3_);
        }
        if (!itemstack.isEmpty()) {
            if (itemstack.getCount() < this.item.getItemStackLimit(itemstack)) {
                p_addLoot_1_.add(itemstack);
            } else {
                ItemStack itemstack1;
                for (int i = itemstack.getCount(); i > 0; i -= itemstack1.getCount()) {
                    itemstack1 = itemstack.copy();
                    itemstack1.setCount(Math.min(itemstack.getMaxStackSize(), i));
                    p_addLoot_1_.add(itemstack1);
                }
            }
        }
    }

    @Override
    protected void serialize(JsonObject p_serialize_1_, JsonSerializationContext p_serialize_2_) {
        ResourceLocation resourcelocation;
        if (this.functions != null && this.functions.length > 0) {
            p_serialize_1_.add("functions", p_serialize_2_.serialize((Object)this.functions));
        }
        if ((resourcelocation = Item.REGISTRY.getNameForObject(this.item)) == null) {
            throw new IllegalArgumentException("Can't serialize unknown item " + this.item);
        }
        p_serialize_1_.addProperty("name", resourcelocation.toString());
    }

    public static LootEntryItem deserialize(JsonObject p_deserialize_0_, JsonDeserializationContext p_deserialize_1_, int p_deserialize_2_, int p_deserialize_3_, LootCondition[] p_deserialize_4_) {
        String name = ForgeHooks.readLootEntryName(p_deserialize_0_, "item");
        Item item = JsonUtils.getItem(p_deserialize_0_, "name");
        LootFunction[] alootfunction = p_deserialize_0_.has("functions") ? JsonUtils.deserializeClass(p_deserialize_0_, "functions", p_deserialize_1_, LootFunction[].class) : new LootFunction[]{};
        return new LootEntryItem(item, p_deserialize_2_, p_deserialize_3_, alootfunction, p_deserialize_4_, name);
    }
}

