/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.ForgeHooks;

public class LootEntryTable
extends LootEntry {
    protected final ResourceLocation table;

    public LootEntryTable(ResourceLocation p_i15_1_, int p_i15_2_, int p_i15_3_, LootCondition[] p_i15_4_, String p_i15_5_) {
        super(p_i15_2_, p_i15_3_, p_i15_4_, p_i15_5_);
        this.table = p_i15_1_;
    }

    @Override
    public void addLoot(Collection<ItemStack> p_addLoot_1_, Random p_addLoot_2_, LootContext p_addLoot_3_) {
        LootTable loottable = p_addLoot_3_.getLootTableManager().getLootTableFromLocation(this.table);
        List<ItemStack> collection = loottable.generateLootForPools(p_addLoot_2_, p_addLoot_3_);
        p_addLoot_1_.addAll(collection);
    }

    @Override
    protected void serialize(JsonObject p_serialize_1_, JsonSerializationContext p_serialize_2_) {
        p_serialize_1_.addProperty("name", this.table.toString());
    }

    public static LootEntryTable deserialize(JsonObject p_deserialize_0_, JsonDeserializationContext p_deserialize_1_, int p_deserialize_2_, int p_deserialize_3_, LootCondition[] p_deserialize_4_) {
        String name = ForgeHooks.readLootEntryName(p_deserialize_0_, "loot_table");
        ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.getString(p_deserialize_0_, "name"));
        return new LootEntryTable(resourcelocation, p_deserialize_2_, p_deserialize_3_, p_deserialize_4_, name);
    }
}

