/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.common.ForgeHooks;

public class LootPool {
    private final List<LootEntry> lootEntries;
    private final List<LootCondition> poolConditions;
    private RandomValueRange rolls;
    private RandomValueRange bonusRolls;
    private final String name;
    private boolean isFrozen = false;

    public LootPool(LootEntry[] p_i14_1_, LootCondition[] p_i14_2_, RandomValueRange p_i14_3_, RandomValueRange p_i14_4_, String p_i14_5_) {
        this.lootEntries = Lists.newArrayList((Object[])p_i14_1_);
        this.poolConditions = Lists.newArrayList((Object[])p_i14_2_);
        this.rolls = p_i14_3_;
        this.bonusRolls = p_i14_4_;
        this.name = p_i14_5_;
    }

    protected void createLootRoll(Collection<ItemStack> p_createLootRoll_1_, Random p_createLootRoll_2_, LootContext p_createLootRoll_3_) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (LootEntry lootentry : this.lootEntries) {
            int j;
            if (!LootConditionManager.testAllConditions(lootentry.conditions, p_createLootRoll_2_, p_createLootRoll_3_) || (j = lootentry.getEffectiveWeight(p_createLootRoll_3_.getLuck())) <= 0) continue;
            list.add(lootentry);
            i += j;
        }
        if (i != 0 && !list.isEmpty()) {
            int k = p_createLootRoll_2_.nextInt(i);
            for (LootEntry lootentry1 : list) {
                if ((k -= lootentry1.getEffectiveWeight(p_createLootRoll_3_.getLuck())) >= 0) continue;
                lootentry1.addLoot(p_createLootRoll_1_, p_createLootRoll_2_, p_createLootRoll_3_);
                return;
            }
        }
    }

    public void generateLoot(Collection<ItemStack> p_generateLoot_1_, Random p_generateLoot_2_, LootContext p_generateLoot_3_) {
        if (LootConditionManager.testAllConditions(this.poolConditions, p_generateLoot_2_, p_generateLoot_3_)) {
            int i = this.rolls.generateInt(p_generateLoot_2_) + MathHelper.floor(this.bonusRolls.generateFloat(p_generateLoot_2_) * p_generateLoot_3_.getLuck());
            for (int j = 0; j < i; ++j) {
                this.createLootRoll(p_generateLoot_1_, p_generateLoot_2_, p_generateLoot_3_);
            }
        }
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootPool after being frozen!");
        }
    }

    public String getName() {
        return this.name;
    }

    public RandomValueRange getRolls() {
        return this.rolls;
    }

    public RandomValueRange getBonusRolls() {
        return this.bonusRolls;
    }

    public void setRolls(RandomValueRange p_setRolls_1_) {
        this.checkFrozen();
        this.rolls = p_setRolls_1_;
    }

    public void setBonusRolls(RandomValueRange p_setBonusRolls_1_) {
        this.checkFrozen();
        this.bonusRolls = p_setBonusRolls_1_;
    }

    public LootEntry getEntry(String p_getEntry_1_) {
        for (LootEntry entry : this.lootEntries) {
            if (!p_getEntry_1_.equals(entry.getEntryName())) continue;
            return entry;
        }
        return null;
    }

    public LootEntry removeEntry(String p_removeEntry_1_) {
        this.checkFrozen();
        for (LootEntry entry : this.lootEntries) {
            if (!p_removeEntry_1_.equals(entry.getEntryName())) continue;
            this.lootEntries.remove(entry);
            return entry;
        }
        return null;
    }

    public void addEntry(LootEntry p_addEntry_1_) {
        this.checkFrozen();
        for (LootEntry e : this.lootEntries) {
            if (e != p_addEntry_1_ && !e.getEntryName().equals(p_addEntry_1_.getEntryName())) continue;
            throw new RuntimeException("Attempted to add a duplicate entry to pool: " + e.getEntryName());
        }
        this.lootEntries.add(p_addEntry_1_);
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.getJsonObject(p_deserialize_1_, "loot pool");
            String name = ForgeHooks.readPoolName(jsonobject);
            LootEntry[] alootentry = JsonUtils.deserializeClass(jsonobject, "entries", p_deserialize_3_, LootEntry[].class);
            LootCondition[] alootcondition = JsonUtils.deserializeClass(jsonobject, "conditions", new LootCondition[0], p_deserialize_3_, LootCondition[].class);
            RandomValueRange randomvaluerange = JsonUtils.deserializeClass(jsonobject, "rolls", p_deserialize_3_, RandomValueRange.class);
            RandomValueRange randomvaluerange1 = JsonUtils.deserializeClass(jsonobject, "bonus_rolls", new RandomValueRange(0.0f, 0.0f), p_deserialize_3_, RandomValueRange.class);
            return new LootPool(alootentry, alootcondition, randomvaluerange, randomvaluerange1, name);
        }

        public JsonElement serialize(LootPool p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            if (p_serialize_1_.name != null && !p_serialize_1_.name.startsWith("custom#")) {
                jsonobject.add("name", p_serialize_3_.serialize((Object)p_serialize_1_.name));
            }
            jsonobject.add("entries", p_serialize_3_.serialize((Object)p_serialize_1_.lootEntries));
            jsonobject.add("rolls", p_serialize_3_.serialize((Object)p_serialize_1_.rolls));
            if (p_serialize_1_.bonusRolls.getMin() != 0.0f && p_serialize_1_.bonusRolls.getMax() != 0.0f) {
                jsonobject.add("bonus_rolls", p_serialize_3_.serialize((Object)p_serialize_1_.bonusRolls));
            }
            if (!p_serialize_1_.poolConditions.isEmpty()) {
                jsonobject.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.poolConditions));
            }
            return jsonobject;
        }
    }
}

