/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final LootTable EMPTY_LOOT_TABLE = new LootTable(new LootPool[0]);
    private final List<LootPool> pools;
    private boolean isFrozen = false;

    public LootTable(LootPool[] p_i46641_1_) {
        this.pools = Lists.newArrayList((Object[])p_i46641_1_);
    }

    public List<ItemStack> generateLootForPools(Random p_generateLootForPools_1_, LootContext p_generateLootForPools_2_) {
        ArrayList list = Lists.newArrayList();
        if (p_generateLootForPools_2_.addLootTable(this)) {
            for (LootPool lootpool : this.pools) {
                lootpool.generateLoot(list, p_generateLootForPools_1_, p_generateLootForPools_2_);
            }
            p_generateLootForPools_2_.removeLootTable(this);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
        return list;
    }

    public void fillInventory(IInventory p_fillInventory_1_, Random p_fillInventory_2_, LootContext p_fillInventory_3_) {
        List<ItemStack> list = this.generateLootForPools(p_fillInventory_2_, p_fillInventory_3_);
        List<Integer> list1 = this.getEmptySlotsRandomized(p_fillInventory_1_, p_fillInventory_2_);
        this.shuffleItems(list, list1.size(), p_fillInventory_2_);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.isEmpty()) {
                p_fillInventory_1_.setInventorySlotContents(list1.remove(list1.size() - 1), ItemStack.EMPTY);
                continue;
            }
            p_fillInventory_1_.setInventorySlotContents(list1.remove(list1.size() - 1), itemstack);
        }
    }

    private void shuffleItems(List<ItemStack> p_shuffleItems_1_, int p_shuffleItems_2_, Random p_shuffleItems_3_) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = p_shuffleItems_1_.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (itemstack.getCount() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        p_shuffleItems_2_ -= p_shuffleItems_1_.size();
        while (p_shuffleItems_2_ > 0 && list.size() > 0) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.getInt(p_shuffleItems_3_, 0, list.size() - 1));
            int i = MathHelper.getInt(p_shuffleItems_3_, 1, itemstack2.getCount() / 2);
            ItemStack itemstack1 = itemstack2.splitStack(i);
            if (itemstack2.getCount() > 1 && p_shuffleItems_3_.nextBoolean()) {
                list.add(itemstack2);
            } else {
                p_shuffleItems_1_.add(itemstack2);
            }
            if (itemstack1.getCount() > 1 && p_shuffleItems_3_.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            p_shuffleItems_1_.add(itemstack1);
        }
        p_shuffleItems_1_.addAll(list);
        Collections.shuffle(p_shuffleItems_1_, p_shuffleItems_3_);
    }

    private List<Integer> getEmptySlotsRandomized(IInventory p_getEmptySlotsRandomized_1_, Random p_getEmptySlotsRandomized_2_) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < p_getEmptySlotsRandomized_1_.getSizeInventory(); ++i) {
            if (!p_getEmptySlotsRandomized_1_.getStackInSlot(i).isEmpty()) continue;
            list.add(i);
        }
        Collections.shuffle(list, p_getEmptySlotsRandomized_2_);
        return list;
    }

    public void freeze() {
        this.isFrozen = true;
        for (LootPool pool : this.pools) {
            pool.freeze();
        }
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public LootPool getPool(String p_getPool_1_) {
        for (LootPool pool : this.pools) {
            if (!p_getPool_1_.equals(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    public LootPool removePool(String p_removePool_1_) {
        this.checkFrozen();
        for (LootPool pool : this.pools) {
            if (!p_removePool_1_.equals(pool.getName())) continue;
            this.pools.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(LootPool p_addPool_1_) {
        this.checkFrozen();
        for (LootPool p : this.pools) {
            if (p != p_addPool_1_ && !p.getName().equals(p_addPool_1_.getName())) continue;
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + p_addPool_1_.getName());
        }
        this.pools.add(p_addPool_1_);
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.getJsonObject(p_deserialize_1_, "loot table");
            LootPool[] alootpool = JsonUtils.deserializeClass(jsonobject, "pools", new LootPool[0], p_deserialize_3_, LootPool[].class);
            return new LootTable(alootpool);
        }

        public JsonElement serialize(LootTable p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("pools", p_serialize_3_.serialize((Object)p_serialize_1_.pools));
            return jsonobject;
        }
    }
}

