/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private final LoadingCache<ResourceLocation, LootTable> registeredLootTables = CacheBuilder.newBuilder().build((CacheLoader)new Loader());
    private final File baseFolder;

    public LootTableManager(File p_i46632_1_) {
        this.baseFolder = p_i46632_1_;
        this.reloadLootTables();
    }

    public LootTable getLootTableFromLocation(ResourceLocation p_getLootTableFromLocation_1_) {
        return (LootTable)this.registeredLootTables.getUnchecked((Object)p_getLootTableFromLocation_1_);
    }

    public void reloadLootTables() {
        this.registeredLootTables.invalidateAll();
        for (ResourceLocation resourcelocation : LootTableList.getAll()) {
            this.getLootTableFromLocation(resourcelocation);
        }
    }

    class Loader
    extends CacheLoader<ResourceLocation, LootTable> {
        private Loader() {
        }

        public LootTable load(ResourceLocation p_load_1_) throws Exception {
            if (p_load_1_.getResourcePath().contains(".")) {
                LOGGER.debug("Invalid loot table name '{}' (can't contain periods)", new Object[]{p_load_1_});
                return LootTable.EMPTY_LOOT_TABLE;
            }
            LootTable loottable = this.loadLootTable(p_load_1_);
            if (loottable == null) {
                loottable = this.loadBuiltinLootTable(p_load_1_);
            }
            if (loottable == null) {
                loottable = LootTable.EMPTY_LOOT_TABLE;
                LOGGER.warn("Couldn't find resource table {}", new Object[]{p_load_1_});
            }
            return loottable;
        }

        @Nullable
        private LootTable loadLootTable(ResourceLocation p_loadLootTable_1_) {
            File file1 = new File(new File(LootTableManager.this.baseFolder, p_loadLootTable_1_.getResourceDomain()), p_loadLootTable_1_.getResourcePath() + ".json");
            if (file1.exists()) {
                if (file1.isFile()) {
                    String s;
                    try {
                        s = Files.toString((File)file1, (Charset)Charsets.UTF_8);
                    }
                    catch (IOException ioexception) {
                        LOGGER.warn("Couldn't load loot table {} from {}", new Object[]{p_loadLootTable_1_, file1, ioexception});
                        return LootTable.EMPTY_LOOT_TABLE;
                    }
                    try {
                        return ForgeHooks.loadLootTable(GSON_INSTANCE, p_loadLootTable_1_, s, true);
                    }
                    catch (JsonParseException jsonparseexception) {
                        LOGGER.error("Couldn't load loot table {} from {}", new Object[]{p_loadLootTable_1_, file1, jsonparseexception});
                        return LootTable.EMPTY_LOOT_TABLE;
                    }
                }
                LOGGER.warn("Expected to find loot table {} at {} but it was a folder.", new Object[]{p_loadLootTable_1_, file1});
                return LootTable.EMPTY_LOOT_TABLE;
            }
            return null;
        }

        @Nullable
        private LootTable loadBuiltinLootTable(ResourceLocation p_loadBuiltinLootTable_1_) {
            URL url = LootTableManager.class.getResource("/assets/" + p_loadBuiltinLootTable_1_.getResourceDomain() + "/loot_tables/" + p_loadBuiltinLootTable_1_.getResourcePath() + ".json");
            if (url != null) {
                String s;
                try {
                    s = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Couldn't load loot table {} from {}", new Object[]{p_loadBuiltinLootTable_1_, url, ioexception});
                    return LootTable.EMPTY_LOOT_TABLE;
                }
                try {
                    return ForgeHooks.loadLootTable(GSON_INSTANCE, p_loadBuiltinLootTable_1_, s, false);
                }
                catch (JsonParseException jsonparseexception) {
                    LOGGER.error("Couldn't load loot table {} from {}", new Object[]{p_loadBuiltinLootTable_1_, url, jsonparseexception});
                    return LootTable.EMPTY_LOOT_TABLE;
                }
            }
            return null;
        }
    }
}

