/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;

public class RandomValueRange {
    private final float min;
    private final float max;

    public RandomValueRange(float p_i46629_1_, float p_i46629_2_) {
        this.min = p_i46629_1_;
        this.max = p_i46629_2_;
    }

    public RandomValueRange(float p_i46630_1_) {
        this.min = p_i46630_1_;
        this.max = p_i46630_1_;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public int generateInt(Random p_generateInt_1_) {
        return MathHelper.getInt(p_generateInt_1_, MathHelper.floor(this.min), MathHelper.floor(this.max));
    }

    public float generateFloat(Random p_generateFloat_1_) {
        return MathHelper.nextFloat(p_generateFloat_1_, this.min, this.max);
    }

    public boolean isInRange(int p_isInRange_1_) {
        return (float)p_isInRange_1_ <= this.max && (float)p_isInRange_1_ >= this.min;
    }

    public static class Serializer
    implements JsonDeserializer<RandomValueRange>,
    JsonSerializer<RandomValueRange> {
        public RandomValueRange deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            if (JsonUtils.isNumber(p_deserialize_1_)) {
                return new RandomValueRange(JsonUtils.getFloat(p_deserialize_1_, "value"));
            }
            JsonObject lvt_4_1_ = JsonUtils.getJsonObject(p_deserialize_1_, "value");
            float lvt_5_1_ = JsonUtils.getFloat(lvt_4_1_, "min");
            float lvt_6_1_ = JsonUtils.getFloat(lvt_4_1_, "max");
            return new RandomValueRange(lvt_5_1_, lvt_6_1_);
        }

        public JsonElement serialize(RandomValueRange p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            if (p_serialize_1_.min == p_serialize_1_.max) {
                return new JsonPrimitive((Number)Float.valueOf(p_serialize_1_.min));
            }
            JsonObject lvt_4_1_ = new JsonObject();
            lvt_4_1_.addProperty("min", (Number)Float.valueOf(p_serialize_1_.min));
            lvt_4_1_.addProperty("max", (Number)Float.valueOf(p_serialize_1_.max));
            return lvt_4_1_;
        }

        public /* synthetic */ JsonElement serialize(Object p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return this.serialize((RandomValueRange)p_serialize_1_, p_serialize_2_, p_serialize_3_);
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

