/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraft.world.storage.loot.properties.EntityPropertyManager;

public class EntityHasProperty
implements LootCondition {
    private final EntityProperty[] properties;
    private final LootContext.EntityTarget target;

    public EntityHasProperty(EntityProperty[] p_i46617_1_, LootContext.EntityTarget p_i46617_2_) {
        this.properties = p_i46617_1_;
        this.target = p_i46617_2_;
    }

    @Override
    public boolean testCondition(Random p_testCondition_1_, LootContext p_testCondition_2_) {
        Entity lvt_3_1_ = p_testCondition_2_.getEntity(this.target);
        if (lvt_3_1_ == null) {
            return false;
        }
        for (EntityProperty lvt_7_1_ : this.properties) {
            if (lvt_7_1_.testProperty(p_testCondition_1_, lvt_3_1_)) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    extends LootCondition.Serializer<EntityHasProperty> {
        protected Serializer() {
            super(new ResourceLocation("entity_properties"), EntityHasProperty.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, EntityHasProperty p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject lvt_4_1_ = new JsonObject();
            for (EntityProperty lvt_8_1_ : p_serialize_2_.properties) {
                EntityProperty.Serializer<EntityProperty> lvt_9_1_ = EntityPropertyManager.getSerializerFor(lvt_8_1_);
                lvt_4_1_.add(lvt_9_1_.getName().toString(), lvt_9_1_.serialize(lvt_8_1_, p_serialize_3_));
            }
            p_serialize_1_.add("properties", (JsonElement)lvt_4_1_);
            p_serialize_1_.add("entity", p_serialize_3_.serialize((Object)p_serialize_2_.target));
        }

        @Override
        public EntityHasProperty deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_) {
            Set lvt_3_1_ = JsonUtils.getJsonObject(p_deserialize_1_, "properties").entrySet();
            EntityProperty[] lvt_4_1_ = new EntityProperty[lvt_3_1_.size()];
            int lvt_5_1_ = 0;
            for (Map.Entry lvt_7_1_ : lvt_3_1_) {
                lvt_4_1_[lvt_5_1_++] = EntityPropertyManager.getSerializerForName(new ResourceLocation((String)lvt_7_1_.getKey())).deserialize((JsonElement)lvt_7_1_.getValue(), p_deserialize_2_);
            }
            return new EntityHasProperty(lvt_4_1_, JsonUtils.deserializeClass(p_deserialize_1_, "entity", p_deserialize_2_, LootContext.EntityTarget.class));
        }

        @Override
        public /* synthetic */ LootCondition deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_);
        }
    }
}

