/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class EntityHasScore
implements LootCondition {
    private final Map<String, RandomValueRange> scores;
    private final LootContext.EntityTarget target;

    public EntityHasScore(Map<String, RandomValueRange> p_i46618_1_, LootContext.EntityTarget p_i46618_2_) {
        this.scores = p_i46618_1_;
        this.target = p_i46618_2_;
    }

    @Override
    public boolean testCondition(Random p_testCondition_1_, LootContext p_testCondition_2_) {
        Entity lvt_3_1_ = p_testCondition_2_.getEntity(this.target);
        if (lvt_3_1_ == null) {
            return false;
        }
        Scoreboard lvt_4_1_ = lvt_3_1_.world.getScoreboard();
        for (Map.Entry<String, RandomValueRange> lvt_6_1_ : this.scores.entrySet()) {
            if (this.entityScoreMatch(lvt_3_1_, lvt_4_1_, lvt_6_1_.getKey(), lvt_6_1_.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean entityScoreMatch(Entity p_entityScoreMatch_1_, Scoreboard p_entityScoreMatch_2_, String p_entityScoreMatch_3_, RandomValueRange p_entityScoreMatch_4_) {
        String lvt_6_1_;
        ScoreObjective lvt_5_1_ = p_entityScoreMatch_2_.getObjective(p_entityScoreMatch_3_);
        if (lvt_5_1_ == null) {
            return false;
        }
        String string = lvt_6_1_ = p_entityScoreMatch_1_ instanceof EntityPlayerMP ? p_entityScoreMatch_1_.getName() : p_entityScoreMatch_1_.getCachedUniqueIdString();
        if (!p_entityScoreMatch_2_.entityHasObjective(lvt_6_1_, lvt_5_1_)) {
            return false;
        }
        return p_entityScoreMatch_4_.isInRange(p_entityScoreMatch_2_.getOrCreateScore(lvt_6_1_, lvt_5_1_).getScorePoints());
    }

    public static class Serializer
    extends LootCondition.Serializer<EntityHasScore> {
        protected Serializer() {
            super(new ResourceLocation("entity_scores"), EntityHasScore.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, EntityHasScore p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject lvt_4_1_ = new JsonObject();
            for (Map.Entry lvt_6_1_ : p_serialize_2_.scores.entrySet()) {
                lvt_4_1_.add((String)lvt_6_1_.getKey(), p_serialize_3_.serialize(lvt_6_1_.getValue()));
            }
            p_serialize_1_.add("scores", (JsonElement)lvt_4_1_);
            p_serialize_1_.add("entity", p_serialize_3_.serialize((Object)p_serialize_2_.target));
        }

        @Override
        public EntityHasScore deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_) {
            Set lvt_3_1_ = JsonUtils.getJsonObject(p_deserialize_1_, "scores").entrySet();
            LinkedHashMap lvt_4_1_ = Maps.newLinkedHashMap();
            for (Map.Entry lvt_6_1_ : lvt_3_1_) {
                lvt_4_1_.put(lvt_6_1_.getKey(), JsonUtils.deserializeClass((JsonElement)lvt_6_1_.getValue(), "score", p_deserialize_2_, RandomValueRange.class));
            }
            return new EntityHasScore(lvt_4_1_, JsonUtils.deserializeClass(p_deserialize_1_, "entity", p_deserialize_2_, LootContext.EntityTarget.class));
        }

        @Override
        public /* synthetic */ LootCondition deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_);
        }
    }
}

