/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class RandomChance
implements LootCondition {
    private final float chance;

    public RandomChance(float p_i46615_1_) {
        this.chance = p_i46615_1_;
    }

    @Override
    public boolean testCondition(Random p_testCondition_1_, LootContext p_testCondition_2_) {
        return p_testCondition_1_.nextFloat() < this.chance;
    }

    public static class Serializer
    extends LootCondition.Serializer<RandomChance> {
        protected Serializer() {
            super(new ResourceLocation("random_chance"), RandomChance.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, RandomChance p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            p_serialize_1_.addProperty("chance", (Number)Float.valueOf(p_serialize_2_.chance));
        }

        @Override
        public RandomChance deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_) {
            return new RandomChance(JsonUtils.getFloat(p_deserialize_1_, "chance"));
        }

        @Override
        public /* synthetic */ LootCondition deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_);
        }
    }
}

