/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class RandomChanceWithLooting
implements LootCondition {
    private final float chance;
    private final float lootingMultiplier;

    public RandomChanceWithLooting(float p_i46614_1_, float p_i46614_2_) {
        this.chance = p_i46614_1_;
        this.lootingMultiplier = p_i46614_2_;
    }

    @Override
    public boolean testCondition(Random p_testCondition_1_, LootContext p_testCondition_2_) {
        int i = p_testCondition_2_.getLootingModifier();
        return p_testCondition_1_.nextFloat() < this.chance + (float)i * this.lootingMultiplier;
    }

    public static class Serializer
    extends LootCondition.Serializer<RandomChanceWithLooting> {
        protected Serializer() {
            super(new ResourceLocation("random_chance_with_looting"), RandomChanceWithLooting.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, RandomChanceWithLooting p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            p_serialize_1_.addProperty("chance", (Number)Float.valueOf(p_serialize_2_.chance));
            p_serialize_1_.addProperty("looting_multiplier", (Number)Float.valueOf(p_serialize_2_.lootingMultiplier));
        }

        @Override
        public RandomChanceWithLooting deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_) {
            return new RandomChanceWithLooting(JsonUtils.getFloat(p_deserialize_1_, "chance"), JsonUtils.getFloat(p_deserialize_1_, "looting_multiplier"));
        }
    }
}

