/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchantRandomly
extends LootFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Enchantment> enchantments;

    public EnchantRandomly(LootCondition[] p_i46628_1_, List<Enchantment> p_i46628_2_) {
        super(p_i46628_1_);
        this.enchantments = p_i46628_2_ == null ? Collections.emptyList() : p_i46628_2_;
    }

    @Override
    public ItemStack apply(ItemStack p_apply_1_, Random p_apply_2_, LootContext p_apply_3_) {
        Enchantment lvt_4_2_;
        if (this.enchantments.isEmpty()) {
            ArrayList lvt_5_1_ = Lists.newArrayList();
            for (Enchantment lvt_7_1_ : Enchantment.REGISTRY) {
                if (p_apply_1_.getItem() != Items.BOOK && !lvt_7_1_.canApply(p_apply_1_)) continue;
                lvt_5_1_.add(lvt_7_1_);
            }
            if (lvt_5_1_.isEmpty()) {
                LOGGER.warn("Couldn't find a compatible enchantment for {}", new Object[]{p_apply_1_});
                return p_apply_1_;
            }
            Enchantment lvt_4_1_ = (Enchantment)lvt_5_1_.get(p_apply_2_.nextInt(lvt_5_1_.size()));
        } else {
            lvt_4_2_ = this.enchantments.get(p_apply_2_.nextInt(this.enchantments.size()));
        }
        int lvt_5_2_ = MathHelper.getInt(p_apply_2_, lvt_4_2_.getMinLevel(), lvt_4_2_.getMaxLevel());
        if (p_apply_1_.getItem() == Items.BOOK) {
            p_apply_1_ = new ItemStack(Items.ENCHANTED_BOOK);
            Items.ENCHANTED_BOOK.addEnchantment(p_apply_1_, new EnchantmentData(lvt_4_2_, lvt_5_2_));
        } else {
            p_apply_1_.addEnchantment(lvt_4_2_, lvt_5_2_);
        }
        return p_apply_1_;
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantRandomly> {
        public Serializer() {
            super(new ResourceLocation("enchant_randomly"), EnchantRandomly.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, EnchantRandomly p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            if (!p_serialize_2_.enchantments.isEmpty()) {
                JsonArray lvt_4_1_ = new JsonArray();
                for (Enchantment lvt_6_1_ : p_serialize_2_.enchantments) {
                    ResourceLocation lvt_7_1_ = Enchantment.REGISTRY.getNameForObject(lvt_6_1_);
                    if (lvt_7_1_ == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + lvt_6_1_);
                    }
                    lvt_4_1_.add((JsonElement)new JsonPrimitive(lvt_7_1_.toString()));
                }
                p_serialize_1_.add("enchantments", (JsonElement)lvt_4_1_);
            }
        }

        @Override
        public EnchantRandomly deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            ArrayList lvt_4_1_ = Lists.newArrayList();
            if (p_deserialize_1_.has("enchantments")) {
                JsonArray lvt_5_1_ = JsonUtils.getJsonArray(p_deserialize_1_, "enchantments");
                for (JsonElement lvt_7_1_ : lvt_5_1_) {
                    String lvt_8_1_ = JsonUtils.getString(lvt_7_1_, "enchantment");
                    Enchantment lvt_9_1_ = Enchantment.REGISTRY.getObject(new ResourceLocation(lvt_8_1_));
                    if (lvt_9_1_ == null) {
                        throw new JsonSyntaxException("Unknown enchantment '" + lvt_8_1_ + "'");
                    }
                    lvt_4_1_.add(lvt_9_1_);
                }
            }
            return new EnchantRandomly(p_deserialize_3_, lvt_4_1_);
        }

        @Override
        public /* synthetic */ LootFunction deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

