/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class EnchantWithLevels
extends LootFunction {
    private final RandomValueRange randomLevel;
    private final boolean isTreasure;

    public EnchantWithLevels(LootCondition[] p_i46627_1_, RandomValueRange p_i46627_2_, boolean p_i46627_3_) {
        super(p_i46627_1_);
        this.randomLevel = p_i46627_2_;
        this.isTreasure = p_i46627_3_;
    }

    @Override
    public ItemStack apply(ItemStack p_apply_1_, Random p_apply_2_, LootContext p_apply_3_) {
        return EnchantmentHelper.addRandomEnchantment(p_apply_2_, p_apply_1_, this.randomLevel.generateInt(p_apply_2_), this.isTreasure);
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantWithLevels> {
        public Serializer() {
            super(new ResourceLocation("enchant_with_levels"), EnchantWithLevels.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, EnchantWithLevels p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            p_serialize_1_.add("levels", p_serialize_3_.serialize((Object)p_serialize_2_.randomLevel));
            p_serialize_1_.addProperty("treasure", Boolean.valueOf(p_serialize_2_.isTreasure));
        }

        @Override
        public EnchantWithLevels deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            RandomValueRange lvt_4_1_ = JsonUtils.deserializeClass(p_deserialize_1_, "levels", p_deserialize_2_, RandomValueRange.class);
            boolean lvt_5_1_ = JsonUtils.getBoolean(p_deserialize_1_, "treasure", false);
            return new EnchantWithLevels(p_deserialize_3_, lvt_4_1_, lvt_5_1_);
        }

        @Override
        public /* synthetic */ LootFunction deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

