/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetAttributes;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraft.world.storage.loot.functions.Smelt;

public class LootFunctionManager {
    private static final Map<ResourceLocation, LootFunction.Serializer<?>> NAME_TO_SERIALIZER_MAP = Maps.newHashMap();
    private static final Map<Class<? extends LootFunction>, LootFunction.Serializer<?>> CLASS_TO_SERIALIZER_MAP = Maps.newHashMap();

    public static <T extends LootFunction> void registerFunction(LootFunction.Serializer<? extends T> p_registerFunction_0_) {
        ResourceLocation lvt_1_1_ = p_registerFunction_0_.getFunctionName();
        Class<T> lvt_2_1_ = p_registerFunction_0_.getFunctionClass();
        if (NAME_TO_SERIALIZER_MAP.containsKey(lvt_1_1_)) {
            throw new IllegalArgumentException("Can't re-register item function name " + lvt_1_1_);
        }
        if (CLASS_TO_SERIALIZER_MAP.containsKey(lvt_2_1_)) {
            throw new IllegalArgumentException("Can't re-register item function class " + lvt_2_1_.getName());
        }
        NAME_TO_SERIALIZER_MAP.put(lvt_1_1_, p_registerFunction_0_);
        CLASS_TO_SERIALIZER_MAP.put(lvt_2_1_, p_registerFunction_0_);
    }

    public static LootFunction.Serializer<?> getSerializerForName(ResourceLocation p_getSerializerForName_0_) {
        LootFunction.Serializer<?> lvt_1_1_ = NAME_TO_SERIALIZER_MAP.get(p_getSerializerForName_0_);
        if (lvt_1_1_ == null) {
            throw new IllegalArgumentException("Unknown loot item function '" + p_getSerializerForName_0_ + "'");
        }
        return lvt_1_1_;
    }

    public static <T extends LootFunction> LootFunction.Serializer<T> getSerializerFor(T p_getSerializerFor_0_) {
        LootFunction.Serializer<?> lvt_1_1_ = CLASS_TO_SERIALIZER_MAP.get(p_getSerializerFor_0_.getClass());
        if (lvt_1_1_ == null) {
            throw new IllegalArgumentException("Unknown loot item function " + p_getSerializerFor_0_);
        }
        return lvt_1_1_;
    }

    static {
        LootFunctionManager.registerFunction(new SetCount.Serializer());
        LootFunctionManager.registerFunction(new SetMetadata.Serializer());
        LootFunctionManager.registerFunction(new EnchantWithLevels.Serializer());
        LootFunctionManager.registerFunction(new EnchantRandomly.Serializer());
        LootFunctionManager.registerFunction(new SetNBT.Serializer());
        LootFunctionManager.registerFunction(new Smelt.Serializer());
        LootFunctionManager.registerFunction(new LootingEnchantBonus.Serializer());
        LootFunctionManager.registerFunction(new SetDamage.Serializer());
        LootFunctionManager.registerFunction(new SetAttributes.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<LootFunction>,
    JsonSerializer<LootFunction> {
        /*
         * WARNING - void declaration
         */
        public LootFunction deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            void lvt_6_2_;
            JsonObject lvt_4_1_ = JsonUtils.getJsonObject(p_deserialize_1_, "function");
            ResourceLocation lvt_5_1_ = new ResourceLocation(JsonUtils.getString(lvt_4_1_, "function"));
            try {
                LootFunction.Serializer<?> lvt_6_1_ = LootFunctionManager.getSerializerForName(lvt_5_1_);
            }
            catch (IllegalArgumentException lvt_7_1_) {
                throw new JsonSyntaxException("Unknown function '" + lvt_5_1_ + "'");
            }
            return lvt_6_2_.deserialize(lvt_4_1_, p_deserialize_3_, JsonUtils.deserializeClass(lvt_4_1_, "conditions", new LootCondition[0], p_deserialize_3_, LootCondition[].class));
        }

        public JsonElement serialize(LootFunction p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            LootFunction.Serializer<LootFunction> lvt_4_1_ = LootFunctionManager.getSerializerFor(p_serialize_1_);
            JsonObject lvt_5_1_ = new JsonObject();
            lvt_4_1_.serialize(lvt_5_1_, p_serialize_1_, p_serialize_3_);
            lvt_5_1_.addProperty("function", lvt_4_1_.getFunctionName().toString());
            if (p_serialize_1_.getConditions() != null && p_serialize_1_.getConditions().length > 0) {
                lvt_5_1_.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.getConditions()));
            }
            return lvt_5_1_;
        }

        public /* synthetic */ JsonElement serialize(Object p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return this.serialize((LootFunction)p_serialize_1_, p_serialize_2_, p_serialize_3_);
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

