/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootingEnchantBonus
extends LootFunction {
    private final RandomValueRange count;
    private final int limit;

    public LootingEnchantBonus(LootCondition[] p_i47145_1_, RandomValueRange p_i47145_2_, int p_i47145_3_) {
        super(p_i47145_1_);
        this.count = p_i47145_2_;
        this.limit = p_i47145_3_;
    }

    @Override
    public ItemStack apply(ItemStack p_apply_1_, Random p_apply_2_, LootContext p_apply_3_) {
        Entity entity = p_apply_3_.getKiller();
        if (entity instanceof EntityLivingBase) {
            int i = p_apply_3_.getLootingModifier();
            if (i == 0) {
                return p_apply_1_;
            }
            float f = (float)i * this.count.generateFloat(p_apply_2_);
            p_apply_1_.grow(Math.round(f));
            if (this.limit != 0 && p_apply_1_.getCount() > this.limit) {
                p_apply_1_.setCount(this.limit);
            }
        }
        return p_apply_1_;
    }

    public static class Serializer
    extends LootFunction.Serializer<LootingEnchantBonus> {
        protected Serializer() {
            super(new ResourceLocation("looting_enchant"), LootingEnchantBonus.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, LootingEnchantBonus p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            p_serialize_1_.add("count", p_serialize_3_.serialize((Object)p_serialize_2_.count));
            if (p_serialize_2_.limit > 0) {
                p_serialize_1_.add("limit", p_serialize_3_.serialize((Object)p_serialize_2_.limit));
            }
        }

        @Override
        public LootingEnchantBonus deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            int i = JsonUtils.getInt(p_deserialize_1_, "limit", 0);
            return new LootingEnchantBonus(p_deserialize_3_, JsonUtils.deserializeClass(p_deserialize_1_, "count", p_deserialize_2_, RandomValueRange.class), i);
        }
    }
}

