/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetAttributes
extends LootFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Modifier[] modifiers;

    public SetAttributes(LootCondition[] p_i46624_1_, Modifier[] p_i46624_2_) {
        super(p_i46624_1_);
        this.modifiers = p_i46624_2_;
    }

    @Override
    public ItemStack apply(ItemStack p_apply_1_, Random p_apply_2_, LootContext p_apply_3_) {
        for (Modifier lvt_7_1_ : this.modifiers) {
            UUID lvt_8_1_ = lvt_7_1_.uuid;
            if (lvt_8_1_ == null) {
                lvt_8_1_ = UUID.randomUUID();
            }
            EntityEquipmentSlot lvt_9_1_ = lvt_7_1_.slots[p_apply_2_.nextInt(lvt_7_1_.slots.length)];
            p_apply_1_.addAttributeModifier(lvt_7_1_.attributeName, new AttributeModifier(lvt_8_1_, lvt_7_1_.modifierName, lvt_7_1_.amount.generateFloat(p_apply_2_), lvt_7_1_.operation), lvt_9_1_);
        }
        return p_apply_1_;
    }

    static class Modifier {
        private final String modifierName;
        private final String attributeName;
        private final int operation;
        private final RandomValueRange amount;
        @Nullable
        private final UUID uuid;
        private final EntityEquipmentSlot[] slots;

        private Modifier(String p_i46561_1_, String p_i46561_2_, int p_i46561_3_, RandomValueRange p_i46561_4_, EntityEquipmentSlot[] p_i46561_5_, UUID p_i46561_6_) {
            this.modifierName = p_i46561_1_;
            this.attributeName = p_i46561_2_;
            this.operation = p_i46561_3_;
            this.amount = p_i46561_4_;
            this.uuid = p_i46561_6_;
            this.slots = p_i46561_5_;
        }

        public JsonObject serialize(JsonSerializationContext p_serialize_1_) {
            JsonObject lvt_2_1_ = new JsonObject();
            lvt_2_1_.addProperty("name", this.modifierName);
            lvt_2_1_.addProperty("attribute", this.attributeName);
            lvt_2_1_.addProperty("operation", Modifier.getOperationFromStr(this.operation));
            lvt_2_1_.add("amount", p_serialize_1_.serialize((Object)this.amount));
            if (this.uuid != null) {
                lvt_2_1_.addProperty("id", this.uuid.toString());
            }
            if (this.slots.length == 1) {
                lvt_2_1_.addProperty("slot", this.slots[0].getName());
            } else {
                JsonArray lvt_3_1_ = new JsonArray();
                for (EntityEquipmentSlot lvt_7_1_ : this.slots) {
                    lvt_3_1_.add((JsonElement)new JsonPrimitive(lvt_7_1_.getName()));
                }
                lvt_2_1_.add("slot", (JsonElement)lvt_3_1_);
            }
            return lvt_2_1_;
        }

        /*
         * WARNING - void declaration
         */
        public static Modifier deserialize(JsonObject p_deserialize_0_, JsonDeserializationContext p_deserialize_1_) {
            void lvt_6_3_;
            String lvt_2_1_ = JsonUtils.getString(p_deserialize_0_, "name");
            String lvt_3_1_ = JsonUtils.getString(p_deserialize_0_, "attribute");
            int lvt_4_1_ = Modifier.getOperationFromInt(JsonUtils.getString(p_deserialize_0_, "operation"));
            RandomValueRange lvt_5_1_ = JsonUtils.deserializeClass(p_deserialize_0_, "amount", p_deserialize_1_, RandomValueRange.class);
            UUID lvt_7_1_ = null;
            if (JsonUtils.isString(p_deserialize_0_, "slot")) {
                EntityEquipmentSlot[] lvt_6_1_ = new EntityEquipmentSlot[]{EntityEquipmentSlot.fromString(JsonUtils.getString(p_deserialize_0_, "slot"))};
            } else if (JsonUtils.isJsonArray(p_deserialize_0_, "slot")) {
                JsonArray lvt_8_1_ = JsonUtils.getJsonArray(p_deserialize_0_, "slot");
                EntityEquipmentSlot[] lvt_6_2_ = new EntityEquipmentSlot[lvt_8_1_.size()];
                int lvt_9_1_ = 0;
                for (JsonElement lvt_11_1_ : lvt_8_1_) {
                    lvt_6_2_[lvt_9_1_++] = EntityEquipmentSlot.fromString(JsonUtils.getString(lvt_11_1_, "slot"));
                }
                if (lvt_6_2_.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            } else {
                throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
            }
            if (p_deserialize_0_.has("id")) {
                String lvt_8_2_ = JsonUtils.getString(p_deserialize_0_, "id");
                try {
                    lvt_7_1_ = UUID.fromString(lvt_8_2_);
                }
                catch (IllegalArgumentException lvt_9_2_) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + lvt_8_2_ + "' (must be UUID format, with dashes)");
                }
            }
            return new Modifier(lvt_2_1_, lvt_3_1_, lvt_4_1_, lvt_5_1_, (EntityEquipmentSlot[])lvt_6_3_, lvt_7_1_);
        }

        private static String getOperationFromStr(int p_getOperationFromStr_0_) {
            switch (p_getOperationFromStr_0_) {
                case 0: {
                    return "addition";
                }
                case 1: {
                    return "multiply_base";
                }
                case 2: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException("Unknown operation " + p_getOperationFromStr_0_);
        }

        private static int getOperationFromInt(String p_getOperationFromInt_0_) {
            if ("addition".equals(p_getOperationFromInt_0_)) {
                return 0;
            }
            if ("multiply_base".equals(p_getOperationFromInt_0_)) {
                return 1;
            }
            if ("multiply_total".equals(p_getOperationFromInt_0_)) {
                return 2;
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + p_getOperationFromInt_0_);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<SetAttributes> {
        public Serializer() {
            super(new ResourceLocation("set_attributes"), SetAttributes.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, SetAttributes p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonArray lvt_4_1_ = new JsonArray();
            for (Modifier lvt_8_1_ : p_serialize_2_.modifiers) {
                lvt_4_1_.add((JsonElement)lvt_8_1_.serialize(p_serialize_3_));
            }
            p_serialize_1_.add("modifiers", (JsonElement)lvt_4_1_);
        }

        @Override
        public SetAttributes deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            JsonArray lvt_4_1_ = JsonUtils.getJsonArray(p_deserialize_1_, "modifiers");
            Modifier[] lvt_5_1_ = new Modifier[lvt_4_1_.size()];
            int lvt_6_1_ = 0;
            for (JsonElement lvt_8_1_ : lvt_4_1_) {
                lvt_5_1_[lvt_6_1_++] = Modifier.deserialize(JsonUtils.getJsonObject(lvt_8_1_, "modifier"), p_deserialize_2_);
            }
            if (lvt_5_1_.length == 0) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new SetAttributes(p_deserialize_3_, lvt_5_1_);
        }

        @Override
        public /* synthetic */ LootFunction deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

