/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetMetadata
extends LootFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RandomValueRange metaRange;

    public SetMetadata(LootCondition[] p_i46621_1_, RandomValueRange p_i46621_2_) {
        super(p_i46621_1_);
        this.metaRange = p_i46621_2_;
    }

    @Override
    public ItemStack apply(ItemStack p_apply_1_, Random p_apply_2_, LootContext p_apply_3_) {
        if (p_apply_1_.isItemStackDamageable()) {
            LOGGER.warn("Couldn't set data of loot item {}", new Object[]{p_apply_1_});
        } else {
            p_apply_1_.setItemDamage(this.metaRange.generateInt(p_apply_2_));
        }
        return p_apply_1_;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetMetadata> {
        protected Serializer() {
            super(new ResourceLocation("set_data"), SetMetadata.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, SetMetadata p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            p_serialize_1_.add("data", p_serialize_3_.serialize((Object)p_serialize_2_.metaRange));
        }

        @Override
        public SetMetadata deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            return new SetMetadata(p_deserialize_3_, JsonUtils.deserializeClass(p_deserialize_1_, "data", p_deserialize_2_, RandomValueRange.class));
        }

        @Override
        public /* synthetic */ LootFunction deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

