/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class SetNBT
extends LootFunction {
    private final NBTTagCompound tag;

    public SetNBT(LootCondition[] p_i46620_1_, NBTTagCompound p_i46620_2_) {
        super(p_i46620_1_);
        this.tag = p_i46620_2_;
    }

    @Override
    public ItemStack apply(ItemStack p_apply_1_, Random p_apply_2_, LootContext p_apply_3_) {
        NBTTagCompound lvt_4_1_ = p_apply_1_.getTagCompound();
        if (lvt_4_1_ == null) {
            lvt_4_1_ = this.tag.copy();
        } else {
            lvt_4_1_.merge(this.tag);
        }
        p_apply_1_.setTagCompound(lvt_4_1_);
        return p_apply_1_;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetNBT> {
        public Serializer() {
            super(new ResourceLocation("set_nbt"), SetNBT.class);
        }

        @Override
        public void serialize(JsonObject p_serialize_1_, SetNBT p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            p_serialize_1_.addProperty("tag", p_serialize_2_.tag.toString());
        }

        @Override
        public SetNBT deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            try {
                NBTTagCompound lvt_4_1_ = JsonToNBT.getTagFromJson(JsonUtils.getString(p_deserialize_1_, "tag"));
                return new SetNBT(p_deserialize_3_, lvt_4_1_);
            }
            catch (NBTException lvt_4_2_) {
                throw new JsonSyntaxException((Throwable)lvt_4_2_);
            }
        }

        @Override
        public /* synthetic */ LootFunction deserialize(JsonObject p_deserialize_1_, JsonDeserializationContext p_deserialize_2_, LootCondition[] p_deserialize_3_) {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

