/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.properties;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.properties.EntityOnFire;
import net.minecraft.world.storage.loot.properties.EntityProperty;

public class EntityPropertyManager {
    private static final Map<ResourceLocation, EntityProperty.Serializer<?>> NAME_TO_SERIALIZER_MAP = Maps.newHashMap();
    private static final Map<Class<? extends EntityProperty>, EntityProperty.Serializer<?>> CLASS_TO_SERIALIZER_MAP = Maps.newHashMap();

    public static <T extends EntityProperty> void registerProperty(EntityProperty.Serializer<? extends T> p_registerProperty_0_) {
        ResourceLocation lvt_1_1_ = p_registerProperty_0_.getName();
        Class<T> lvt_2_1_ = p_registerProperty_0_.getPropertyClass();
        if (NAME_TO_SERIALIZER_MAP.containsKey(lvt_1_1_)) {
            throw new IllegalArgumentException("Can't re-register entity property name " + lvt_1_1_);
        }
        if (CLASS_TO_SERIALIZER_MAP.containsKey(lvt_2_1_)) {
            throw new IllegalArgumentException("Can't re-register entity property class " + lvt_2_1_.getName());
        }
        NAME_TO_SERIALIZER_MAP.put(lvt_1_1_, p_registerProperty_0_);
        CLASS_TO_SERIALIZER_MAP.put(lvt_2_1_, p_registerProperty_0_);
    }

    public static EntityProperty.Serializer<?> getSerializerForName(ResourceLocation p_getSerializerForName_0_) {
        EntityProperty.Serializer<?> lvt_1_1_ = NAME_TO_SERIALIZER_MAP.get(p_getSerializerForName_0_);
        if (lvt_1_1_ == null) {
            throw new IllegalArgumentException("Unknown loot entity property '" + p_getSerializerForName_0_ + "'");
        }
        return lvt_1_1_;
    }

    public static <T extends EntityProperty> EntityProperty.Serializer<T> getSerializerFor(T p_getSerializerFor_0_) {
        EntityProperty.Serializer<?> lvt_1_1_ = CLASS_TO_SERIALIZER_MAP.get(p_getSerializerFor_0_.getClass());
        if (lvt_1_1_ == null) {
            throw new IllegalArgumentException("Unknown loot entity property " + p_getSerializerFor_0_);
        }
        return lvt_1_1_;
    }

    static {
        EntityPropertyManager.registerProperty(new EntityOnFire.Serializer());
    }
}

