/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ClientCommandHandler
extends CommandHandler {
    public static final ClientCommandHandler instance = new ClientCommandHandler();
    public String[] latestAutoComplete = null;

    @Override
    public int executeCommand(ICommandSender sender, String message) {
        if ((message = message.trim()).startsWith("/")) {
            message = message.substring(1);
        }
        String[] temp = message.split(" ");
        String[] args = new String[temp.length - 1];
        String commandName = temp[0];
        System.arraycopy(temp, 1, args, 0, args.length);
        ICommand icommand = this.getCommands().get(commandName);
        try {
            if (icommand == null) {
                return 0;
            }
            if (icommand.checkPermission(this.getServer(), sender)) {
                CommandEvent event = new CommandEvent(icommand, sender, args);
                if (MinecraftForge.EVENT_BUS.post(event)) {
                    if (event.getException() != null) {
                        throw event.getException();
                    }
                    return 0;
                }
                this.tryExecute(sender, args, icommand, message);
                return 1;
            }
            sender.sendMessage(this.format(TextFormatting.RED, "commands.generic.permission", new Object[0]));
        }
        catch (WrongUsageException wue) {
            sender.sendMessage(this.format(TextFormatting.RED, "commands.generic.usage", this.format(TextFormatting.RED, wue.getMessage(), wue.getErrorObjects())));
        }
        catch (CommandException ce) {
            sender.sendMessage(this.format(TextFormatting.RED, ce.getMessage(), ce.getErrorObjects()));
        }
        catch (Throwable t) {
            sender.sendMessage(this.format(TextFormatting.RED, "commands.generic.exception", new Object[0]));
            t.printStackTrace();
        }
        return -1;
    }

    private TextComponentTranslation format(TextFormatting color, String str, Object ... args) {
        TextComponentTranslation ret = new TextComponentTranslation(str, args);
        ret.getStyle().setColor(color);
        return ret;
    }

    public void autoComplete(String leftOfCursor) {
        this.latestAutoComplete = null;
        if (leftOfCursor.charAt(0) == '/') {
            List<String> commands;
            leftOfCursor = leftOfCursor.substring(1);
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc.currentScreen instanceof GuiChat && !(commands = this.getTabCompletions(mc.player, leftOfCursor, mc.player.getPosition())).isEmpty()) {
                if (leftOfCursor.indexOf(32) == -1) {
                    for (int i = 0; i < commands.size(); ++i) {
                        commands.set(i, (Object)((Object)TextFormatting.GRAY) + "/" + commands.get(i) + (Object)((Object)TextFormatting.RESET));
                    }
                } else {
                    for (int i = 0; i < commands.size(); ++i) {
                        commands.set(i, (Object)((Object)TextFormatting.GRAY) + commands.get(i) + (Object)((Object)TextFormatting.RESET));
                    }
                }
                this.latestAutoComplete = commands.toArray(new String[commands.size()]);
            }
        }
    }

    @Override
    protected MinecraftServer getServer() {
        return Minecraft.getMinecraft().getIntegratedServer();
    }
}

