/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;

public class ItemModelMesherForge
extends ItemModelMesher {
    IdentityHashMap<Item, TIntObjectHashMap<ModelResourceLocation>> locations = Maps.newIdentityHashMap();
    IdentityHashMap<Item, TIntObjectHashMap<IBakedModel>> models = Maps.newIdentityHashMap();

    public ItemModelMesherForge(ModelManager manager) {
        super(manager);
    }

    @Override
    protected IBakedModel getItemModel(Item item, int meta) {
        TIntObjectHashMap<IBakedModel> map = this.models.get(item);
        return map == null ? null : (IBakedModel)map.get(meta);
    }

    @Override
    public void register(Item item, int meta, ModelResourceLocation location) {
        TIntObjectHashMap locs = this.locations.get(item);
        TIntObjectHashMap mods = this.models.get(item);
        if (locs == null) {
            locs = new TIntObjectHashMap();
            this.locations.put(item, (TIntObjectHashMap<ModelResourceLocation>)locs);
        }
        if (mods == null) {
            mods = new TIntObjectHashMap();
            this.models.put(item, (TIntObjectHashMap<IBakedModel>)mods);
        }
        locs.put(meta, (Object)location);
        mods.put(meta, (Object)this.getModelManager().getModel(location));
    }

    @Override
    public void rebuildCache() {
        final ModelManager manager = this.getModelManager();
        for (Map.Entry<Item, TIntObjectHashMap<ModelResourceLocation>> e : this.locations.entrySet()) {
            TIntObjectHashMap mods = this.models.get(e.getKey());
            if (mods != null) {
                mods.clear();
            } else {
                mods = new TIntObjectHashMap();
                this.models.put(e.getKey(), (TIntObjectHashMap<IBakedModel>)mods);
            }
            final TIntObjectHashMap map = mods;
            e.getValue().forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<ModelResourceLocation>(){

                public boolean execute(int meta, ModelResourceLocation location) {
                    map.put(meta, (Object)manager.getModel(location));
                    return true;
                }
            });
        }
    }
}

