/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.BitSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;

public class MinecraftForgeClient {
    private static BitSet stencilBits = new BitSet(8);
    private static final LoadingCache<Pair<World, BlockPos>, ChunkCache> regionCache;

    public static int getRenderPass() {
        return ForgeHooksClient.renderPass;
    }

    public static BlockRenderLayer getRenderLayer() {
        return ForgeHooksClient.renderLayer.get();
    }

    public static Locale getLocale() {
        return Minecraft.getMinecraft().getLanguageManager().getCurrentLanguage().getJavaLocale();
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < stencilBits.length()) {
            stencilBits.set(bit);
        }
    }

    public static void onRebuildChunk(World world, BlockPos position, ChunkCache cache) {
        regionCache.put((Object)Pair.of((Object)world, (Object)position), (Object)cache);
    }

    public static ChunkCache getRegionRenderCache(World world, BlockPos pos) {
        int x = pos.getX() & 0xFFFFFFF0;
        int y = pos.getY() & 0xFFFFFFF0;
        int z = pos.getZ() & 0xFFFFFFF0;
        return (ChunkCache)regionCache.getUnchecked((Object)Pair.of((Object)world, (Object)new BlockPos(x, y, z)));
    }

    static {
        stencilBits.set(0, 8);
        regionCache = CacheBuilder.newBuilder().maximumSize(500L).concurrencyLevel(5).expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<World, BlockPos>, ChunkCache>(){

            public ChunkCache load(Pair<World, BlockPos> key) throws Exception {
                return new ChunkCache((World)key.getLeft(), ((BlockPos)key.getRight()).add(-1, -1, -1), ((BlockPos)key.getRight()).add(16, 16, 16), 1);
            }
        });
    }
}

