/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenEvent
extends Event {
    private final GuiScreen gui;

    public GuiScreenEvent(GuiScreen gui) {
        this.gui = gui;
    }

    public GuiScreen getGui() {
        return this.gui;
    }

    public static class KeyboardInputEvent
    extends GuiScreenEvent {
        public KeyboardInputEvent(GuiScreen gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends KeyboardInputEvent {
            public Post(GuiScreen gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardInputEvent {
            public Pre(GuiScreen gui) {
                super(gui);
            }
        }
    }

    public static class MouseInputEvent
    extends GuiScreenEvent {
        public MouseInputEvent(GuiScreen gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends MouseInputEvent {
            public Post(GuiScreen gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseInputEvent {
            public Pre(GuiScreen gui) {
                super(gui);
            }
        }
    }

    public static class ActionPerformedEvent
    extends GuiScreenEvent {
        private GuiButton button;
        private List<GuiButton> buttonList;

        public ActionPerformedEvent(GuiScreen gui, GuiButton button, List<GuiButton> buttonList) {
            super(gui);
            this.setButton(button);
            this.setButtonList(new ArrayList<GuiButton>(buttonList));
        }

        public GuiButton getButton() {
            return this.button;
        }

        public void setButton(GuiButton button) {
            this.button = button;
        }

        public List<GuiButton> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<GuiButton> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends ActionPerformedEvent {
            public Post(GuiScreen gui, GuiButton button, List<GuiButton> buttonList) {
                super(gui, button, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends ActionPerformedEvent {
            public Pre(GuiScreen gui, GuiButton button, List<GuiButton> buttonList) {
                super(gui, button, buttonList);
            }
        }
    }

    @Cancelable
    public static class PotionShiftEvent
    extends GuiScreenEvent {
        public PotionShiftEvent(GuiScreen gui) {
            super(gui);
        }
    }

    public static class BackgroundDrawnEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;

        public BackgroundDrawnEvent(GuiScreen gui) {
            super(gui);
            ScaledResolution scaledresolution = new ScaledResolution(gui.mc);
            int scaledWidth = scaledresolution.getScaledWidth();
            int scaledHeight = scaledresolution.getScaledHeight();
            this.mouseX = Mouse.getX() * scaledWidth / gui.mc.displayWidth;
            this.mouseY = scaledHeight - Mouse.getY() * scaledHeight / gui.mc.displayHeight - 1;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }
    }

    public static class DrawScreenEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;
        private final float renderPartialTicks;

        public DrawScreenEvent(GuiScreen gui, int mouseX, int mouseY, float renderPartialTicks) {
            super(gui);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.renderPartialTicks = renderPartialTicks;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getRenderPartialTicks() {
            return this.renderPartialTicks;
        }

        public static class Post
        extends DrawScreenEvent {
            public Post(GuiScreen gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }

        @Cancelable
        public static class Pre
        extends DrawScreenEvent {
            public Pre(GuiScreen gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }
    }

    public static class InitGuiEvent
    extends GuiScreenEvent {
        private List<GuiButton> buttonList;

        public InitGuiEvent(GuiScreen gui, List<GuiButton> buttonList) {
            super(gui);
            this.setButtonList(buttonList);
        }

        public List<GuiButton> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<GuiButton> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends InitGuiEvent {
            public Post(GuiScreen gui, List<GuiButton> buttonList) {
                super(gui, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends InitGuiEvent {
            public Pre(GuiScreen gui, List<GuiButton> buttonList) {
                super(gui, buttonList);
            }
        }
    }
}

