/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.ArrayList;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.world.BossInfoLerping;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class RenderGameOverlayEvent
extends Event {
    private final float partialTicks;
    private final ScaledResolution resolution;
    private final ElementType type;

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public ScaledResolution getResolution() {
        return this.resolution;
    }

    public ElementType getType() {
        return this.type;
    }

    public RenderGameOverlayEvent(float partialTicks, ScaledResolution resolution) {
        this.partialTicks = partialTicks;
        this.resolution = resolution;
        this.type = null;
    }

    private RenderGameOverlayEvent(RenderGameOverlayEvent parent, ElementType type) {
        this.partialTicks = parent.getPartialTicks();
        this.resolution = parent.getResolution();
        this.type = type;
    }

    public static class Chat
    extends Pre {
        private int posX;
        private int posY;

        public Chat(RenderGameOverlayEvent parent, int posX, int posY) {
            super(parent, ElementType.CHAT);
            this.setPosX(posX);
            this.setPosY(posY);
        }

        public int getPosX() {
            return this.posX;
        }

        public void setPosX(int posX) {
            this.posX = posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public void setPosY(int posY) {
            this.posY = posY;
        }
    }

    public static class Text
    extends Pre {
        private final ArrayList<String> left;
        private final ArrayList<String> right;

        public Text(RenderGameOverlayEvent parent, ArrayList<String> left, ArrayList<String> right) {
            super(parent, ElementType.TEXT);
            this.left = left;
            this.right = right;
        }

        public ArrayList<String> getLeft() {
            return this.left;
        }

        public ArrayList<String> getRight() {
            return this.right;
        }
    }

    public static class BossInfo
    extends Pre {
        private final BossInfoLerping bossInfo;
        private final int x;
        private final int y;
        private int increment;

        public BossInfo(RenderGameOverlayEvent parent, ElementType type, BossInfoLerping bossInfo, int x, int y, int increment) {
            super(parent, type);
            this.bossInfo = bossInfo;
            this.x = x;
            this.y = y;
            this.increment = increment;
        }

        public BossInfoLerping getBossInfo() {
            return this.bossInfo;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }
    }

    public static class Post
    extends RenderGameOverlayEvent {
        public Post(RenderGameOverlayEvent parent, ElementType type) {
            super(parent, type);
        }

        @Override
        public boolean isCancelable() {
            return false;
        }
    }

    public static class Pre
    extends RenderGameOverlayEvent {
        public Pre(RenderGameOverlayEvent parent, ElementType type) {
            super(parent, type);
        }
    }

    public static enum ElementType {
        ALL,
        HELMET,
        PORTAL,
        CROSSHAIRS,
        BOSSHEALTH,
        BOSSINFO,
        ARMOR,
        HEALTH,
        FOOD,
        AIR,
        HOTBAR,
        EXPERIENCE,
        TEXT,
        HEALTHMOUNT,
        JUMPBAR,
        CHAT,
        PLAYER_LIST,
        DEBUG,
        POTION_ICONS,
        SUBTITLES,
        FPS_GRAPH;

    }
}

