/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class NotificationModUpdateScreen
extends GuiScreen {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final GuiButton modButton;
    private ForgeVersion.Status showNotification = null;
    private boolean hasCheckedForUpdates = false;

    public NotificationModUpdateScreen(GuiButton modButton) {
        this.modButton = modButton;
    }

    @Override
    public void initGui() {
        if (!this.hasCheckedForUpdates) {
            if (this.modButton != null) {
                for (ModContainer mod : Loader.instance().getModList()) {
                    ForgeVersion.Status status = ForgeVersion.getResult((ModContainer)mod).status;
                    if (status != ForgeVersion.Status.OUTDATED && status != ForgeVersion.Status.BETA_OUTDATED) continue;
                    this.showNotification = ForgeVersion.Status.OUTDATED;
                }
            }
            this.hasCheckedForUpdates = true;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        if (this.showNotification == null || !this.showNotification.shouldDraw() || ForgeModContainer.disableVersionCheck) {
            return;
        }
        Minecraft.getMinecraft().getTextureManager().bindTexture(VERSION_CHECK_ICONS);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.pushMatrix();
        int x = this.modButton.xPosition;
        int y = this.modButton.yPosition;
        int w = this.modButton.width;
        int h = this.modButton.height;
        NotificationModUpdateScreen.drawModalRectWithCustomSizedTexture(x + w - (h / 2 + 4), y + (h / 2 - 4), this.showNotification.getSheetOffset() * 8, this.showNotification.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f, 8, 8, 64.0f, 16.0f);
        GlStateManager.popMatrix();
    }

    public static NotificationModUpdateScreen init(GuiMainMenu guiMainMenu, GuiButton modButton) {
        NotificationModUpdateScreen notificationModUpdateScreen = new NotificationModUpdateScreen(modButton);
        notificationModUpdateScreen.setGuiSize(guiMainMenu.width, guiMainMenu.height);
        notificationModUpdateScreen.initGui();
        return notificationModUpdateScreen;
    }
}

