/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public interface IPerspectiveAwareModel
extends IBakedModel {
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType var1);

    public static class MapWrapper
    implements IPerspectiveAwareModel {
        private final IBakedModel parent;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        public MapWrapper(IBakedModel parent, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            this.parent = parent;
            this.transforms = transforms;
        }

        public MapWrapper(IBakedModel parent, IModelState state) {
            this(parent, MapWrapper.getTransforms(state));
        }

        public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IModelState state) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                Optional<TRSRTransformation> tr = state.apply((Optional<? extends IModelPart>)Optional.of((Object)type));
                if (!tr.isPresent()) continue;
                builder.put((Object)type, tr.get());
            }
            return builder.build();
        }

        public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(ItemCameraTransforms transforms) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner(new TRSRTransformation(transforms.getTransform(type))));
            }
            return builder.build();
        }

        public static Pair<? extends IBakedModel, Matrix4f> handlePerspective(IBakedModel model, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemCameraTransforms.TransformType cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)transforms.get((Object)cameraTransformType);
            Matrix4f mat = null;
            if (tr != null && !tr.equals(TRSRTransformation.identity())) {
                mat = TRSRTransformation.blockCornerToCenter(tr).getMatrix();
            }
            return Pair.of((Object)model, mat);
        }

        public static Pair<? extends IBakedModel, Matrix4f> handlePerspective(IBakedModel model, IModelState state, ItemCameraTransforms.TransformType cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.of((Object)cameraTransformType)).or((Object)TRSRTransformation.identity());
            if (tr != TRSRTransformation.identity()) {
                return Pair.of((Object)model, (Object)TRSRTransformation.blockCornerToCenter(tr).getMatrix());
            }
            return Pair.of((Object)model, null);
        }

        @Override
        public boolean isAmbientOcclusion() {
            return this.parent.isAmbientOcclusion();
        }

        @Override
        public boolean isGui3d() {
            return this.parent.isGui3d();
        }

        @Override
        public boolean isBuiltInRenderer() {
            return this.parent.isBuiltInRenderer();
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return this.parent.getParticleTexture();
        }

        @Override
        public ItemCameraTransforms getItemCameraTransforms() {
            return this.parent.getItemCameraTransforms();
        }

        @Override
        public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
            return this.parent.getQuads(state, side, rand);
        }

        @Override
        public ItemOverrideList getOverrides() {
            return this.parent.getOverrides();
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return MapWrapper.handlePerspective((IBakedModel)this, this.transforms, cameraTransformType);
        }
    }
}

