/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public final class ItemLayerModel
implements IRetexturableModel {
    public static final ItemLayerModel INSTANCE = new ItemLayerModel((ImmutableList<ResourceLocation>)ImmutableList.of());
    private final ImmutableList<ResourceLocation> textures;
    private final ItemOverrideList overrides;

    public ItemLayerModel(ImmutableList<ResourceLocation> textures) {
        this(textures, ItemOverrideList.NONE);
    }

    public ItemLayerModel(ImmutableList<ResourceLocation> textures, ItemOverrideList overrides) {
        this.textures = textures;
        this.overrides = overrides;
    }

    public ItemLayerModel(ModelBlock model) {
        this(ItemLayerModel.getTextures(model), model.createOverrides());
    }

    private static ImmutableList<ResourceLocation> getTextures(ModelBlock model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.isTexturePresent("layer" + i)) {
            builder.add((Object)new ResourceLocation(model.resolveTextureName("layer" + i)));
            ++i;
        }
        return builder.build();
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public ItemLayerModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size() + this.textures.size(); ++i) {
            if (textures.containsKey((Object)("layer" + i))) {
                builder.add((Object)new ResourceLocation((String)textures.get((Object)("layer" + i))));
                continue;
            }
            if (i >= this.textures.size()) continue;
            builder.add(this.textures.get(i));
        }
        return new ItemLayerModel((ImmutableList<ResourceLocation>)builder.build(), this.overrides);
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<TRSRTransformation> transform = state.apply((Optional<? extends IModelPart>)Optional.absent());
        for (int i = 0; i < this.textures.size(); ++i) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)bakedTextureGetter.apply(this.textures.get(i));
            builder.addAll(ItemLayerModel.getQuadsForSprite(i, sprite, format, transform));
        }
        TextureAtlasSprite particle = (TextureAtlasSprite)bakedTextureGetter.apply((Object)(this.textures.isEmpty() ? new ResourceLocation("missingno") : (ResourceLocation)this.textures.get(0)));
        ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        return new BakedItemModel((ImmutableList<BakedQuad>)builder.build(), particle, map, this.overrides, null);
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.getIconWidth();
        int vMax = sprite.getIconHeight();
        BitSet faces = new BitSet((uMax + 1) * (vMax + 1) * 4);
        for (int f = 0; f < sprite.getFrameCount(); ++f) {
            int[] pixels = sprite.getFrameTextureData(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u = 0; u < uMax; ++u) {
                    boolean t = ItemLayerModel.isTransparent(pixels, uMax, vMax, u, v);
                    if (ptu && !t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.WEST, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptu && t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.EAST, tint, sprite, uMax, vMax, u, v);
                    }
                    if (ptv[u] && !t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.UP, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptv[u] && t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.DOWN, tint, sprite, uMax, vMax, u, v);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.EAST, tint, sprite, uMax, vMax, uMax, v);
            }
            for (int u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.DOWN, tint, sprite, uMax, vMax, u, vMax);
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, 0.0f, 0.0f, 0.46875f, sprite.getMinU(), sprite.getMaxV(), 0.0f, 1.0f, 0.46875f, sprite.getMinU(), sprite.getMinV(), 1.0f, 1.0f, 0.46875f, sprite.getMaxU(), sprite.getMinV(), 1.0f, 0.0f, 0.46875f, sprite.getMaxU(), sprite.getMaxV()));
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, 0.0f, 0.0f, 0.53125f, sprite.getMinU(), sprite.getMaxV(), 1.0f, 0.0f, 0.53125f, sprite.getMaxU(), sprite.getMaxV(), 1.0f, 1.0f, 0.53125f, sprite.getMaxU(), sprite.getMinV(), 0.0f, 1.0f, 0.53125f, sprite.getMinU(), sprite.getMinV()));
        return builder.build();
    }

    private static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    private static void addSideQuad(ImmutableList.Builder<BakedQuad> builder, BitSet faces, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int uMax, int vMax, int u, int v) {
        int index;
        int si = side.ordinal();
        if (si > 4) {
            si -= 2;
        }
        if (!faces.get(index = (vMax + 1) * ((uMax + 1) * si + u) + v)) {
            faces.set(index);
            builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, side, tint, sprite, u, v));
        }
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u / (float)sprite.getIconWidth();
        float y0 = (float)v / (float)sprite.getIconHeight();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f;
        float z2 = 0.5317f;
        switch (side) {
            case WEST: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case EAST: {
                y1 = ((float)v + 1.0f) / (float)sprite.getIconHeight();
                break;
            }
            case DOWN: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case UP: {
                x1 = ((float)u + 1.0f) / (float)sprite.getIconWidth();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.getDirectionVec().getX() * 0.5f / (float)sprite.getIconWidth());
        float u1 = 16.0f * (x1 - (float)side.getDirectionVec().getX() * 0.5f / (float)sprite.getIconWidth());
        float v0 = 16.0f * (1.0f - y0 - (float)side.getDirectionVec().getY() * 0.5f / (float)sprite.getIconHeight());
        float v1 = 16.0f * (1.0f - y1 - (float)side.getDirectionVec().getY() * 0.5f / (float)sprite.getIconHeight());
        switch (side) {
            case WEST: 
            case EAST: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.getIconHeight();
                v1 += 0.5f / (float)sprite.getIconHeight();
                break;
            }
            case DOWN: 
            case UP: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.getIconWidth();
                u1 -= 0.5f / (float)sprite.getIconWidth();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case WEST: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case EAST: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case DOWN: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case UP: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return ItemLayerModel.buildQuad(format, transform, side.getOpposite(), sprite, tint, x0, y0, z1, sprite.getInterpolatedU(u0), sprite.getInterpolatedV(v0), x1, y1, z1, sprite.getInterpolatedU(u1), sprite.getInterpolatedV(v1), x1, y1, z2, sprite.getInterpolatedU(u1), sprite.getInterpolatedV(v1), x0, y0, z2, sprite.getInterpolatedU(u0), sprite.getInterpolatedV(v0));
    }

    private static final BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, TextureAtlasSprite sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        ItemLayerModel.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        ItemLayerModel.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        ItemLayerModel.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        ItemLayerModel.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.getElementCount(); ++e) {
            switch (format.getElement(e).getUsage()) {
                case POSITION: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        ((TRSRTransformation)transform.get()).getMatrix().transform((Tuple4f)vec);
                        builder.put(e, vec.x, vec.y, vec.z, vec.w);
                        continue block6;
                    }
                    builder.put(e, x, y, z, 1.0f);
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case UV: {
                    if (format.getElement(e).getIndex() == 0) {
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, side.getFrontOffsetX(), side.getFrontOffsetY(), side.getFrontOffsetZ(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void onResourceManagerReload(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.getResourceDomain().equals("forge") && (modelLocation.getResourcePath().equals("item-layer") || modelLocation.getResourcePath().equals("models/block/item-layer") || modelLocation.getResourcePath().equals("models/item/item-layer"));
        }

        @Override
        public IModel loadModel(ResourceLocation modelLocation) {
            return INSTANCE;
        }
    }

    private static final class BakedItemModel
    implements IPerspectiveAwareModel {
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final IBakedModel otherModel;
        private final boolean isCulled;
        private final ItemOverrideList overrides;

        public BakedItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemOverrideList overrides, @Nullable IBakedModel otherModel) {
            this.quads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            if (otherModel != null) {
                this.otherModel = otherModel;
                this.isCulled = true;
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedQuad quad : quads) {
                    if (quad.getFace() != EnumFacing.SOUTH) continue;
                    builder.add((Object)quad);
                }
                this.otherModel = new BakedItemModel((ImmutableList<BakedQuad>)builder.build(), particle, transforms, overrides, this);
                this.isCulled = false;
            }
        }

        @Override
        public boolean isAmbientOcclusion() {
            return true;
        }

        @Override
        public boolean isGui3d() {
            return false;
        }

        @Override
        public boolean isBuiltInRenderer() {
            return false;
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return this.particle;
        }

        @Override
        public ItemCameraTransforms getItemCameraTransforms() {
            return ItemCameraTransforms.DEFAULT;
        }

        @Override
        public ItemOverrideList getOverrides() {
            return this.overrides;
        }

        @Override
        public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            Pair<? extends IBakedModel, Matrix4f> pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, type);
            if (type == ItemCameraTransforms.TransformType.GUI && !this.isCulled && pair.getRight() == null) {
                return Pair.of((Object)this.otherModel, null);
            }
            if (type != ItemCameraTransforms.TransformType.GUI && this.isCulled) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }
    }
}

