/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiLayerModel
implements IModelCustomData {
    public static final MultiLayerModel INSTANCE = new MultiLayerModel((ImmutableMap<Optional<BlockRenderLayer>, ModelResourceLocation>)ImmutableMap.of());
    private final ImmutableMap<Optional<BlockRenderLayer>, ModelResourceLocation> models;

    public MultiLayerModel(ImmutableMap<Optional<BlockRenderLayer>, ModelResourceLocation> models) {
        this.models = models;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    private static ImmutableMap<Optional<BlockRenderLayer>, IBakedModel> buildModels(ImmutableMap<Optional<BlockRenderLayer>, ModelResourceLocation> models, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)models.get((Object)key), "Couldn't load MultiLayerModel dependency: " + models.get((Object)key));
            builder.put((Object)key, (Object)model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)((Object)layer)), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel((ImmutableMap<Optional<BlockRenderLayer>, ModelResourceLocation>)models);
    }

    private ModelResourceLocation getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new ModelResourceLocation(e.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new ModelResourceLocation("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void onResourceManagerReload(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.getResourceDomain().equals("forge") && (modelLocation.getResourcePath().equals("multi-layer") || modelLocation.getResourcePath().equals("models/block/multi-layer") || modelLocation.getResourcePath().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(ResourceLocation modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<Optional<BlockRenderLayer>, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms;
        private final IBakedModel base;
        private final IBakedModel missing;
        private final ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> quads;

        public MultiLayerBakedModel(ImmutableMap<Optional<BlockRenderLayer>, IBakedModel> models, IBakedModel missing, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.containsKey((Object)Optional.absent()) ? (IBakedModel)models.get((Object)Optional.absent()) : missing;
            ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
            quadBuilder.put((Object)Optional.absent(), MultiLayerBakedModel.buildQuads(models, (Optional<EnumFacing>)Optional.absent()));
            for (EnumFacing side : EnumFacing.values()) {
                quadBuilder.put((Object)Optional.of((Object)side), MultiLayerBakedModel.buildQuads(models, (Optional<EnumFacing>)Optional.of((Object)side)));
            }
            this.quads = quadBuilder.build();
        }

        private static ImmutableList<BakedQuad> buildQuads(ImmutableMap<Optional<BlockRenderLayer>, IBakedModel> models, Optional<EnumFacing> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IBakedModel model : models.values()) {
                builder.addAll(model.getQuads(null, (EnumFacing)side.orNull(), 0L));
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                return (List)this.quads.get((Object)Optional.fromNullable((Object)side));
            }
            IBakedModel model = !this.models.containsKey((Object)Optional.of((Object)((Object)layer))) ? this.missing : (IBakedModel)this.models.get((Object)Optional.of((Object)((Object)layer)));
            return model.getQuads(state, side, rand);
        }

        @Override
        public boolean isAmbientOcclusion() {
            return this.base.isAmbientOcclusion();
        }

        @Override
        public boolean isGui3d() {
            return this.base.isGui3d();
        }

        @Override
        public boolean isBuiltInRenderer() {
            return this.base.isBuiltInRenderer();
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return this.base.getParticleTexture();
        }

        @Override
        public ItemCameraTransforms getItemCameraTransforms() {
            return ItemCameraTransforms.DEFAULT;
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, cameraTransformType);
        }

        @Override
        public ItemOverrideList getOverrides() {
            return ItemOverrideList.NONE;
        }
    }
}

