/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

@Deprecated
public final class MultiModel
implements IModel {
    private final ResourceLocation location;
    private final IModel base;
    private final IModelState baseState;
    private final Map<String, Pair<IModel, IModelState>> parts;

    public MultiModel(ResourceLocation location, IModel base, IModelState baseState, ImmutableMap<String, Pair<IModel, IModelState>> parts) {
        this.location = location;
        this.base = base;
        this.baseState = baseState;
        this.parts = parts;
    }

    public MultiModel(ResourceLocation location, IModel base, IModelState baseState, Map<String, Pair<IModel, IModelState>> parts) {
        this(location, base, baseState, (ImmutableMap<String, Pair<IModel, IModelState>>)ImmutableMap.copyOf(parts));
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getDependencies());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getDependencies());
        }
        return deps;
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getTextures());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getTextures());
        }
        return deps;
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel bakedBase = null;
        if (this.base != null) {
            bakedBase = this.base.bake(state, format, bakedTextureGetter);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Pair<IModel, IModelState>> entry : this.parts.entrySet()) {
            Pair<IModel, IModelState> pair = entry.getValue();
            mapBuilder.put((Object)entry.getKey(), (Object)((IModel)pair.getLeft()).bake(new ModelStateComposition(state, (IModelState)pair.getRight()), format, bakedTextureGetter));
        }
        if (bakedBase == null && this.parts.isEmpty()) {
            FMLLog.log(Level.ERROR, "MultiModel %s is empty (no base model or parts were provided/resolved)", this.location);
            IModel missing = ModelLoaderRegistry.getMissingModel();
            return missing.bake(missing.getDefaultState(), format, bakedTextureGetter);
        }
        return new Baked(this.location, true, bakedBase, (ImmutableMap<String, IBakedModel>)mapBuilder.build());
    }

    @Override
    public IModelState getDefaultState() {
        return this.baseState;
    }

    private static final class Baked
    implements IPerspectiveAwareModel {
        private final ResourceLocation location;
        private final IBakedModel base;
        private final ImmutableMap<String, IBakedModel> parts;
        private final IBakedModel internalBase;
        private ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> quads;
        private final ImmutableMap<ItemCameraTransforms.TransformType, Pair<Baked, TRSRTransformation>> transforms;
        private final ItemOverrideList overrides = new ItemOverrideList(Lists.newArrayList()){

            @Override
            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (originalModel != Baked.this) {
                    return originalModel;
                }
                boolean dirty = false;
                IBakedModel newBase = null;
                if (Baked.this.base != null) {
                    newBase = Baked.this.base.getOverrides().handleItemState(Baked.this.base, stack, world, entity);
                    if (Baked.this.base != newBase) {
                        dirty = true;
                    }
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : Baked.this.parts.entrySet()) {
                    IBakedModel newPart = ((IBakedModel)entry.getValue()).getOverrides().handleItemState((IBakedModel)entry.getValue(), stack, world, entity);
                    builder.put(entry.getKey(), (Object)newPart);
                    if (entry.getValue() == newPart) continue;
                    dirty = true;
                }
                if (dirty) {
                    return new Baked(Baked.this.location, newBase instanceof IPerspectiveAwareModel, newBase, (ImmutableMap<String, IBakedModel>)builder.build());
                }
                return Baked.this;
            }
        };

        public Baked(ResourceLocation location, boolean perspective, IBakedModel base, ImmutableMap<String, IBakedModel> parts) {
            this.location = location;
            this.base = base;
            this.parts = parts;
            if (base != null) {
                this.internalBase = base;
            } else {
                UnmodifiableIterator iter = parts.values().iterator();
                if (iter.hasNext()) {
                    this.internalBase = (IBakedModel)iter.next();
                } else {
                    throw new IllegalArgumentException("No base model or submodel provided for MultiModel.Baked " + location + ".");
                }
            }
            if (perspective && base instanceof IPerspectiveAwareModel) {
                IPerspectiveAwareModel perBase = (IPerspectiveAwareModel)base;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                    Pair<? extends IBakedModel, Matrix4f> p = perBase.handlePerspective(type);
                    IBakedModel newBase = (IBakedModel)p.getLeft();
                    builder.put((Object)type, (Object)Pair.of((Object)new Baked(location, false, newBase, parts), (Object)new TRSRTransformation((Matrix4f)p.getRight())));
                }
                this.transforms = builder.build();
            } else {
                this.transforms = ImmutableMap.of();
            }
        }

        @Override
        public boolean isAmbientOcclusion() {
            return this.internalBase.isAmbientOcclusion();
        }

        @Override
        public boolean isGui3d() {
            return this.internalBase.isGui3d();
        }

        @Override
        public boolean isBuiltInRenderer() {
            return this.internalBase.isBuiltInRenderer();
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return this.internalBase.getParticleTexture();
        }

        @Override
        public ItemCameraTransforms getItemCameraTransforms() {
            return this.internalBase.getItemCameraTransforms();
        }

        @Override
        public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
            if (this.quads == null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (EnumFacing face : EnumFacing.values()) {
                    ImmutableList.Builder quads = ImmutableList.builder();
                    if (this.base != null) {
                        quads.addAll(this.base.getQuads(state, face, 0L));
                    }
                    for (IBakedModel bakedPart : this.parts.values()) {
                        quads.addAll(bakedPart.getQuads(state, face, 0L));
                    }
                    builder.put((Object)Optional.of((Object)face), (Object)quads.build());
                }
                ImmutableList.Builder quads = ImmutableList.builder();
                if (this.base != null) {
                    quads.addAll(this.base.getQuads(state, null, 0L));
                }
                for (IBakedModel bakedPart : this.parts.values()) {
                    quads.addAll(bakedPart.getQuads(state, null, 0L));
                }
                builder.put((Object)Optional.absent(), (Object)quads.build());
                this.quads = builder.build();
            }
            return (List)this.quads.get((Object)Optional.fromNullable((Object)side));
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (this.transforms.isEmpty()) {
                return Pair.of((Object)this, null);
            }
            Pair p = (Pair)this.transforms.get((Object)cameraTransformType);
            return Pair.of((Object)p.getLeft(), (Object)((TRSRTransformation)p.getRight()).getMatrix());
        }

        @Override
        public ItemOverrideList getOverrides() {
            return this.overrides;
        }
    }
}

