/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelSimpleProperties;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.animation.IAnimatedModel;
import net.minecraftforge.client.model.b3d.B3DClip;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public enum B3DLoader implements ICustomModelLoader
{
    INSTANCE;

    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, B3DModel> cache = new HashMap<ResourceLocation, B3DModel>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
    }

    @Override
    public void onResourceManagerReload(IResourceManager manager) {
        this.manager = manager;
        this.cache.clear();
    }

    @Override
    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.getResourceDomain()) && modelLocation.getResourcePath().endsWith(".b3d");
    }

    @Override
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        B3DModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.getResourceDomain(), modelLocation.getResourcePath());
        if (!this.cache.containsKey(file)) {
            try {
                IResource resource = null;
                try {
                    resource = this.manager.getResource(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.getResourcePath().startsWith("models/block/")) {
                        resource = this.manager.getResource(new ResourceLocation(file.getResourceDomain(), "models/item/" + file.getResourcePath().substring("models/block/".length())));
                    }
                    if (modelLocation.getResourcePath().startsWith("models/item/")) {
                        resource = this.manager.getResource(new ResourceLocation(file.getResourceDomain(), "models/block/" + file.getResourcePath().substring("models/item/".length())));
                    }
                    throw e;
                }
                B3DModel.Parser parser = new B3DModel.Parser(resource.getInputStream());
                B3DModel model2 = parser.parse();
                this.cache.put(file, model2);
            }
            catch (IOException e) {
                this.cache.put(file, null);
                throw e;
            }
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file);
        }
        if (!(model.getRoot().getKind() instanceof B3DModel.Mesh)) {
            return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of(), true, true, 1);
        }
        return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of((Object)model.getRoot().getName()), true, true, 1);
    }

    private static final class BakedWrapper
    implements IPerspectiveAwareModel {
        private final B3DModel.Node<?> node;
        private final IModelState state;
        private final boolean smooth;
        private final boolean gui3d;
        private final VertexFormat format;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, TextureAtlasSprite> textures;
        private final LoadingCache<Integer, B3DState> cache;
        private ImmutableList<BakedQuad> quads;

        public BakedWrapper(final B3DModel.Node<?> node, final IModelState state, boolean smooth, boolean gui3d, VertexFormat format, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures) {
            this(node, state, smooth, gui3d, format, meshes, textures, (LoadingCache<Integer, B3DState>)CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, B3DState>(){

                public B3DState load(Integer frame) throws Exception {
                    IModelState parent = state;
                    B3DModel.Animation newAnimation = node.getAnimation();
                    if (parent instanceof B3DState) {
                        B3DState ps = (B3DState)parent;
                        parent = ps.getParent();
                    }
                    return new B3DState(newAnimation, frame, frame, 0.0f, parent);
                }
            }));
        }

        public BakedWrapper(B3DModel.Node<?> node, IModelState state, boolean smooth, boolean gui3d, VertexFormat format, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures, LoadingCache<Integer, B3DState> cache) {
            this.node = node;
            this.state = state;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.format = format;
            this.meshes = meshes;
            this.textures = textures;
            this.cache = cache;
        }

        @Override
        public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
            ImmutableList.Builder builder;
            if (side != null) {
                return ImmutableList.of();
            }
            IModelState modelState = this.state;
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)state;
                if (exState.getUnlistedNames().contains(B3DFrameProperty.INSTANCE)) {
                    B3DState s = exState.getValue(B3DFrameProperty.INSTANCE);
                    if (s != null) {
                        IModelState parent = this.state;
                        B3DModel.Animation newAnimation = s.getAnimation();
                        if (parent instanceof B3DState) {
                            B3DState ps = (B3DState)parent;
                            parent = ps.getParent();
                        }
                        if (newAnimation == null) {
                            newAnimation = this.node.getAnimation();
                        }
                        modelState = s.getFrame() == s.getNextFrame() ? (IModelState)this.cache.getUnchecked((Object)s.getFrame()) : new B3DState(newAnimation, s.getFrame(), s.getNextFrame(), s.getProgress(), parent);
                    }
                } else if (exState.getUnlistedNames().contains(Properties.AnimationProperty)) {
                    IModelState newState;
                    IModelState parent = this.state;
                    if (parent instanceof B3DState) {
                        B3DState ps = (B3DState)parent;
                        parent = ps.getParent();
                    }
                    if ((newState = exState.getValue(Properties.AnimationProperty)) != null) {
                        modelState = new ModelStateComposition(parent, newState);
                    }
                }
            }
            if (this.quads == null) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, this.state, (ImmutableList<String>)ImmutableList.of());
                this.quads = builder.build();
            }
            if (this.state != modelState) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, modelState, (ImmutableList<String>)ImmutableList.of());
                return builder.build();
            }
            return this.quads;
        }

        private void generateQuads(ImmutableList.Builder<BakedQuad> builder, B3DModel.Node<?> node, final IModelState state, ImmutableList<String> path) {
            ImmutableList.Builder pathBuilder = ImmutableList.builder();
            pathBuilder.addAll(path);
            pathBuilder.add((Object)node.getName());
            ImmutableList newPath = pathBuilder.build();
            for (B3DModel.Node child : node.getNodes().values()) {
                this.generateQuads(builder, child, state, (ImmutableList<String>)newPath);
            }
            if (node.getKind() instanceof B3DModel.Mesh && this.meshes.contains((Object)node.getName()) && !state.apply((Optional<? extends IModelPart>)Optional.of((Object)Models.getHiddenModelPart((ImmutableList<String>)newPath))).isPresent()) {
                B3DModel.Mesh mesh = (B3DModel.Mesh)node.getKind();
                ImmutableList<B3DModel.Face> faces = mesh.bake(new Function<B3DModel.Node<?>, Matrix4f>(){
                    private final TRSRTransformation global;
                    private final LoadingCache<B3DModel.Node<?>, TRSRTransformation> localCache;
                    {
                        this.global = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity());
                        this.localCache = CacheBuilder.newBuilder().maximumSize(32L).build(new CacheLoader<B3DModel.Node<?>, TRSRTransformation>(){

                            public TRSRTransformation load(B3DModel.Node<?> node) throws Exception {
                                return (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.of((Object)new NodeJoint(node))).or((Object)TRSRTransformation.identity());
                            }
                        });
                    }

                    public Matrix4f apply(B3DModel.Node<?> node) {
                        return this.global.compose((TRSRTransformation)this.localCache.getUnchecked(node)).getMatrix();
                    }
                });
                for (B3DModel.Face f : faces) {
                    UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
                    quadBuilder.setContractUVs(true);
                    quadBuilder.setQuadOrientation(EnumFacing.getFacingFromVector(f.getNormal().x, f.getNormal().y, f.getNormal().z));
                    List<B3DModel.Texture> textures = null;
                    if (f.getBrush() != null) {
                        textures = f.getBrush().getTextures();
                    }
                    TextureAtlasSprite sprite = textures == null || textures.isEmpty() ? (TextureAtlasSprite)this.textures.get((Object)"missingno") : (textures.get(0) == B3DModel.Texture.White ? ModelLoader.White.INSTANCE : (TextureAtlasSprite)this.textures.get((Object)textures.get(0).getPath()));
                    quadBuilder.setTexture(sprite);
                    this.putVertexData(quadBuilder, f.getV1(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV2(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    builder.add((Object)quadBuilder.build());
                }
            }
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, B3DModel.Vertex v, Vector3f faceNormal, TextureAtlasSprite sprite) {
            block6: for (int e = 0; e < this.format.getElementCount(); ++e) {
                switch (this.format.getElement(e).getUsage()) {
                    case POSITION: {
                        builder.put(e, v.getPos().x, v.getPos().y, v.getPos().z, 1.0f);
                        continue block6;
                    }
                    case COLOR: {
                        if (v.getColor() != null) {
                            builder.put(e, v.getColor().x, v.getColor().y, v.getColor().z, v.getColor().w);
                            continue block6;
                        }
                        builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                        continue block6;
                    }
                    case UV: {
                        if (this.format.getElement(e).getIndex() < v.getTexCoords().length) {
                            builder.put(e, sprite.getInterpolatedU(v.getTexCoords()[0].x * 16.0f), sprite.getInterpolatedV(v.getTexCoords()[0].y * 16.0f), 0.0f, 1.0f);
                            continue block6;
                        }
                        builder.put(e, 0.0f, 0.0f, 0.0f, 1.0f);
                        continue block6;
                    }
                    case NORMAL: {
                        if (v.getNormal() != null) {
                            builder.put(e, v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f);
                            continue block6;
                        }
                        builder.put(e, faceNormal.x, faceNormal.y, faceNormal.z, 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        @Override
        public boolean isAmbientOcclusion() {
            return this.smooth;
        }

        @Override
        public boolean isGui3d() {
            return this.gui3d;
        }

        @Override
        public boolean isBuiltInRenderer() {
            return false;
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return (TextureAtlasSprite)this.textures.values().asList().get(0);
        }

        @Override
        public ItemCameraTransforms getItemCameraTransforms() {
            return ItemCameraTransforms.DEFAULT;
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.state, cameraTransformType);
        }

        @Override
        public ItemOverrideList getOverrides() {
            return ItemOverrideList.NONE;
        }
    }

    private static final class ModelWrapper
    implements IRetexturableModel,
    IModelCustomData,
    IModelSimpleProperties,
    IAnimatedModel {
        private final ResourceLocation modelLocation;
        private final B3DModel model;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, ResourceLocation> textures;
        private final boolean smooth;
        private final boolean gui3d;
        private final int defaultKey;

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, int defaultKey) {
            this(modelLocation, model, meshes, smooth, gui3d, defaultKey, ModelWrapper.buildTextures(model.getTextures()));
        }

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, int defaultKey, ImmutableMap<String, ResourceLocation> textures) {
            this.modelLocation = modelLocation;
            this.model = model;
            this.meshes = meshes;
            this.textures = textures;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.defaultKey = defaultKey;
        }

        private static ImmutableMap<String, ResourceLocation> buildTextures(List<B3DModel.Texture> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (B3DModel.Texture t : textures) {
                String path = t.getPath();
                String location = ModelWrapper.getLocation(path);
                if (!location.startsWith("#")) {
                    location = "#" + location;
                }
                builder.put((Object)path, (Object)new ResourceLocation(location));
            }
            return builder.build();
        }

        private static String getLocation(String path) {
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - ".png".length());
            }
            return path;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public Collection<ResourceLocation> getTextures() {
            return Collections2.filter((Collection)this.textures.values(), (Predicate)new Predicate<ResourceLocation>(){

                public boolean apply(ResourceLocation loc) {
                    return !loc.getResourcePath().startsWith("#");
                }
            });
        }

        @Override
        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TextureAtlasSprite missing = (TextureAtlasSprite)bakedTextureGetter.apply((Object)new ResourceLocation("missingno"));
            for (Map.Entry e : this.textures.entrySet()) {
                if (((ResourceLocation)e.getValue()).getResourcePath().startsWith("#")) {
                    FMLLog.severe("unresolved texture '%s' for b3d model '%s'", ((ResourceLocation)e.getValue()).getResourcePath(), this.modelLocation);
                    builder.put(e.getKey(), (Object)missing);
                    continue;
                }
                builder.put(e.getKey(), bakedTextureGetter.apply(e.getValue()));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new BakedWrapper(this.model.getRoot(), state, this.smooth, this.gui3d, format, this.meshes, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
        }

        @Override
        public ModelWrapper retexture(ImmutableMap<String, String> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry e : this.textures.entrySet()) {
                String path = (String)e.getKey();
                String loc = ModelWrapper.getLocation(path);
                if (textures.containsKey((Object)loc)) {
                    String newLoc = (String)textures.get((Object)loc);
                    if (newLoc == null) {
                        newLoc = ModelWrapper.getLocation(path);
                    }
                    builder.put(e.getKey(), (Object)new ResourceLocation(newLoc));
                    continue;
                }
                builder.put(e);
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, this.gui3d, this.defaultKey, (ImmutableMap<String, ResourceLocation>)builder.build());
        }

        @Override
        public ModelWrapper process(ImmutableMap<String, String> data) {
            if (data.containsKey((Object)"mesh")) {
                JsonElement e = new JsonParser().parse((String)data.get((Object)"mesh"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)ImmutableSet.of((Object)e.getAsString()), this.smooth, this.gui3d, this.defaultKey, this.textures);
                }
                if (e.isJsonArray()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (JsonElement s : e.getAsJsonArray()) {
                        if (s.isJsonPrimitive() && s.getAsJsonPrimitive().isString()) {
                            builder.add((Object)s.getAsString());
                            continue;
                        }
                        FMLLog.severe("unknown mesh definition '%s' in array for b3d model '%s'", s.toString(), this.modelLocation);
                        return this;
                    }
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)builder.build(), this.smooth, this.gui3d, this.defaultKey, this.textures);
                }
                FMLLog.severe("unknown mesh definition '%s' for b3d model '%s'", e.toString(), this.modelLocation);
                return this;
            }
            if (data.containsKey((Object)"key")) {
                JsonElement e = new JsonParser().parse((String)data.get((Object)"key"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, this.gui3d, e.getAsNumber().intValue(), this.textures);
                }
                FMLLog.severe("unknown keyframe definition '%s' for b3d model '%s'", e.toString(), this.modelLocation);
                return this;
            }
            return this;
        }

        public Optional<IClip> getClip(String name) {
            if (name.equals("main")) {
                return Optional.of((Object)B3DClip.INSTANCE);
            }
            return Optional.absent();
        }

        @Override
        public IModelState getDefaultState() {
            return new B3DState(this.model.getRoot().getAnimation(), this.defaultKey, this.defaultKey, 0.0f);
        }

        @Override
        public ModelWrapper smoothLighting(boolean value) {
            if (value == this.smooth) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, value, this.gui3d, this.defaultKey, this.textures);
        }

        @Override
        public ModelWrapper gui3d(boolean value) {
            if (value == this.gui3d) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, value, this.defaultKey, this.textures);
        }
    }

    @Deprecated
    public static enum B3DFrameProperty implements IUnlistedProperty<B3DState>
    {
        INSTANCE;


        @Override
        public String getName() {
            return "B3DFrame";
        }

        @Override
        public boolean isValid(B3DState value) {
            return value instanceof B3DState;
        }

        @Override
        public Class<B3DState> getType() {
            return B3DState.class;
        }

        @Override
        public String valueToString(B3DState value) {
            return value.toString();
        }
    }

    static final class NodeJoint
    implements IJoint {
        private final B3DModel.Node<?> node;

        public NodeJoint(B3DModel.Node<?> node) {
            this.node = node;
        }

        @Override
        public TRSRTransformation getInvBindPose() {
            Matrix4f m = new TRSRTransformation(this.node.getPos(), this.node.getRot(), this.node.getScale(), null).getMatrix();
            m.invert();
            TRSRTransformation pose = new TRSRTransformation(m);
            if (this.node.getParent() != null) {
                TRSRTransformation parent = new NodeJoint(this.node.getParent()).getInvBindPose();
                pose = pose.compose(parent);
            }
            return pose;
        }

        public Optional<NodeJoint> getParent() {
            if (this.node.getParent() == null) {
                return Optional.absent();
            }
            return Optional.of((Object)new NodeJoint(this.node.getParent()));
        }

        public B3DModel.Node<?> getNode() {
            return this.node;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeJoint other = (NodeJoint)obj;
            return Objects.equal(this.node, other.node);
        }
    }

    public static final class B3DState
    implements IModelState {
        private final B3DModel.Animation animation;
        private final int frame;
        private final int nextFrame;
        private final float progress;
        @Nullable
        private final IModelState parent;
        private static LoadingCache<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation> cache = CacheBuilder.newBuilder().maximumSize(16384L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation>(){

            public TRSRTransformation load(Triple<B3DModel.Animation, B3DModel.Node<?>, Integer> key) throws Exception {
                return B3DState.getNodeMatrix((B3DModel.Animation)key.getLeft(), (B3DModel.Node)key.getMiddle(), (Integer)key.getRight());
            }
        });

        public B3DState(B3DModel.Animation animation, int frame) {
            this(animation, frame, frame, 0.0f);
        }

        public B3DState(B3DModel.Animation animation, int frame, IModelState parent) {
            this(animation, frame, frame, 0.0f, parent);
        }

        public B3DState(B3DModel.Animation animation, int frame, int nextFrame, float progress) {
            this(animation, frame, nextFrame, progress, null);
        }

        public B3DState(B3DModel.Animation animation, int frame, int nextFrame, float progress, @Nullable IModelState parent) {
            this.animation = animation;
            this.frame = frame;
            this.nextFrame = nextFrame;
            this.progress = MathHelper.clamp(progress, 0.0f, 1.0f);
            this.parent = this.getParent(parent);
        }

        @Nullable
        private IModelState getParent(@Nullable IModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof B3DState) {
                return ((B3DState)parent).parent;
            }
            return parent;
        }

        public B3DModel.Animation getAnimation() {
            return this.animation;
        }

        public int getFrame() {
            return this.frame;
        }

        public int getNextFrame() {
            return this.nextFrame;
        }

        public float getProgress() {
            return this.progress;
        }

        @Nullable
        public IModelState getParent() {
            return this.parent;
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            TRSRTransformation nodeTransform;
            if (!part.isPresent()) {
                if (this.parent != null) {
                    return this.parent.apply(part);
                }
                return Optional.absent();
            }
            if (!(part.get() instanceof NodeJoint)) {
                return Optional.absent();
            }
            B3DModel.Node<?> node = ((NodeJoint)part.get()).getNode();
            if ((double)this.progress < 1.0E-5 || this.frame == this.nextFrame) {
                nodeTransform = this.getNodeMatrix(node, this.frame);
            } else if ((double)this.progress > 0.99999) {
                nodeTransform = this.getNodeMatrix(node, this.nextFrame);
            } else {
                nodeTransform = this.getNodeMatrix(node, this.frame);
                nodeTransform = nodeTransform.slerp(this.getNodeMatrix(node, this.nextFrame), this.progress);
            }
            if (this.parent != null && node.getParent() == null) {
                return Optional.of((Object)((TRSRTransformation)this.parent.apply(part).or((Object)TRSRTransformation.identity())).compose(nodeTransform));
            }
            return Optional.of((Object)nodeTransform);
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node) {
            return this.getNodeMatrix(node, this.frame);
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node, int frame) {
            return (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)this.animation, node, (Object)frame));
        }

        public static TRSRTransformation getNodeMatrix(B3DModel.Animation animation, B3DModel.Node<?> node, int frame) {
            TRSRTransformation ret = TRSRTransformation.identity();
            B3DModel.Key key = null;
            if (animation != null) {
                key = (B3DModel.Key)animation.getKeys().get((Object)frame, node);
            } else if (node.getAnimation() != null && node.getAnimation() != animation) {
                key = (B3DModel.Key)node.getAnimation().getKeys().get((Object)frame, node);
            }
            if (key != null) {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TRSRTransformation pm = (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.compose(pm);
                    ret = ret.compose(new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.compose(new TRSRTransformation(key.getPos(), key.getRot(), key.getScale(), null));
                TRSRTransformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.compose(invBind);
            } else {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TRSRTransformation pm = (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.compose(pm);
                    ret = ret.compose(new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.compose(new TRSRTransformation(node.getPos(), node.getRot(), node.getScale(), null));
                TRSRTransformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.compose(invBind);
            }
            return ret;
        }
    }
}

