/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public enum OBJLoader implements ICustomModelLoader
{
    INSTANCE;

    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, OBJModel> cache = new HashMap<ResourceLocation, OBJModel>();
    private final Map<ResourceLocation, Exception> errors = new HashMap<ResourceLocation, Exception>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log(Level.INFO, "OBJLoader: Domain %s has been added.", domain.toLowerCase());
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }

    @Override
    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.getResourceDomain()) && modelLocation.getResourcePath().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        OBJModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.getResourceDomain(), modelLocation.getResourcePath());
        if (!this.cache.containsKey(file)) {
            IResource resource = null;
            try {
                resource = this.manager.getResource(file);
            }
            catch (FileNotFoundException e) {
                if (modelLocation.getResourcePath().startsWith("models/block/")) {
                    resource = this.manager.getResource(new ResourceLocation(file.getResourceDomain(), "models/item/" + file.getResourcePath().substring("models/block/".length())));
                }
                if (modelLocation.getResourcePath().startsWith("models/item/")) {
                    resource = this.manager.getResource(new ResourceLocation(file.getResourceDomain(), "models/block/" + file.getResourcePath().substring("models/item/".length())));
                }
                throw e;
            }
            OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
            OBJModel model2 = null;
            try {
                model2 = parser.parse();
            }
            catch (Exception e) {
                this.errors.put(modelLocation, e);
            }
            finally {
                this.cache.put(modelLocation, model2);
            }
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file, this.errors.get(modelLocation));
        }
        return model;
    }
}

