/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.common.ForgeModContainer;

public class ForgeBlockModelRenderer
extends BlockModelRenderer {
    private final ThreadLocal<VertexLighterFlat> lighterFlat = new ThreadLocal<VertexLighterFlat>(){

        @Override
        protected VertexLighterFlat initialValue() {
            return new VertexLighterFlat(ForgeBlockModelRenderer.this.colors);
        }
    };
    private final ThreadLocal<VertexLighterSmoothAo> lighterSmooth = new ThreadLocal<VertexLighterSmoothAo>(){

        @Override
        protected VertexLighterSmoothAo initialValue() {
            return new VertexLighterSmoothAo(ForgeBlockModelRenderer.this.colors);
        }
    };
    private final ThreadLocal<VertexBufferConsumer> wrFlat = new ThreadLocal();
    private final ThreadLocal<VertexBufferConsumer> wrSmooth = new ThreadLocal();
    private final ThreadLocal<VertexBuffer> lastRendererFlat = new ThreadLocal();
    private final ThreadLocal<VertexBuffer> lastRendererSmooth = new ThreadLocal();
    private final BlockColors colors;

    public ForgeBlockModelRenderer(BlockColors colors) {
        super(colors);
        this.colors = colors;
    }

    @Override
    public boolean renderModelFlat(IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, VertexBuffer buffer, boolean checkSides, long rand) {
        if (ForgeModContainer.forgeLightPipelineEnabled) {
            if (buffer != this.lastRendererFlat.get()) {
                this.lastRendererFlat.set(buffer);
                VertexBufferConsumer newCons = new VertexBufferConsumer(buffer);
                this.wrFlat.set(newCons);
                this.lighterFlat.get().setParent(newCons);
            }
            this.wrFlat.get().setOffset(pos);
            return ForgeBlockModelRenderer.render(this.lighterFlat.get(), world, model, state, pos, buffer, checkSides, rand);
        }
        return super.renderModelFlat(world, model, state, pos, buffer, checkSides, rand);
    }

    @Override
    public boolean renderModelSmooth(IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, VertexBuffer buffer, boolean checkSides, long rand) {
        if (ForgeModContainer.forgeLightPipelineEnabled) {
            if (buffer != this.lastRendererSmooth.get()) {
                this.lastRendererSmooth.set(buffer);
                VertexBufferConsumer newCons = new VertexBufferConsumer(buffer);
                this.wrSmooth.set(newCons);
                this.lighterSmooth.get().setParent(newCons);
            }
            this.wrSmooth.get().setOffset(pos);
            return ForgeBlockModelRenderer.render(this.lighterSmooth.get(), world, model, state, pos, buffer, checkSides, rand);
        }
        return super.renderModelSmooth(world, model, state, pos, buffer, checkSides, rand);
    }

    public static boolean render(VertexLighterFlat lighter, IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, VertexBuffer wr, boolean checkSides, long rand) {
        lighter.setWorld(world);
        lighter.setState(state);
        lighter.setBlockPos(pos);
        boolean empty = true;
        List<BakedQuad> quads = model.getQuads(state, null, rand);
        if (!quads.isEmpty()) {
            lighter.updateBlockInfo();
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe(lighter);
            }
        }
        for (EnumFacing side : EnumFacing.values()) {
            quads = model.getQuads(state, side, rand);
            if (quads.isEmpty() || checkSides && !state.shouldSideBeRendered(world, pos, side)) continue;
            if (empty) {
                lighter.updateBlockInfo();
            }
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe(lighter);
            }
        }
        return !empty;
    }
}

