/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import org.apache.commons.lang3.tuple.Pair;

public class LightUtil {
    private static final float s2 = (float)Math.pow(2.0, 0.5);
    private static final LoadingCache<Pair<VertexFormat, VertexFormat>, int[]> formatMaps = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<Pair<VertexFormat, VertexFormat>, int[]>(){

        public int[] load(Pair<VertexFormat, VertexFormat> pair) {
            return LightUtil.mapFormats((VertexFormat)pair.getLeft(), (VertexFormat)pair.getRight());
        }
    });
    private static IVertexConsumer tessellator = null;
    private static ItemConsumer itemConsumer = null;

    public static float diffuseLight(float x, float y, float z) {
        float y1 = y + 3.0f - 2.0f * s2;
        return x * x * 0.6f + y1 * y1 * (3.0f + 2.0f * s2) / 8.0f + z * z * 0.8f;
    }

    public static float diffuseLight(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return 0.5f;
            }
            case UP: {
                return 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
        }
        return 0.6f;
    }

    public static EnumFacing toSide(float x, float y, float z) {
        if (Math.abs(x) > Math.abs(y)) {
            if (Math.abs(x) > Math.abs(z)) {
                if (x < 0.0f) {
                    return EnumFacing.WEST;
                }
                return EnumFacing.EAST;
            }
            if (z < 0.0f) {
                return EnumFacing.NORTH;
            }
            return EnumFacing.SOUTH;
        }
        if (Math.abs(y) > Math.abs(z)) {
            if (y < 0.0f) {
                return EnumFacing.DOWN;
            }
            return EnumFacing.UP;
        }
        if (z < 0.0f) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.SOUTH;
    }

    public static void putBakedQuad(IVertexConsumer consumer, BakedQuad quad) {
        consumer.setTexture(quad.getSprite());
        consumer.setQuadOrientation(quad.getFace());
        if (quad.hasTintIndex()) {
            consumer.setQuadTint(quad.getTintIndex());
        }
        consumer.setApplyDiffuseLighting(quad.shouldApplyDiffuseLighting());
        float[] data = new float[4];
        VertexFormat formatFrom = consumer.getVertexFormat();
        VertexFormat formatTo = quad.getFormat();
        int countFrom = formatFrom.getElementCount();
        int countTo = formatTo.getElementCount();
        int[] eMap = (int[])formatMaps.getUnchecked((Object)Pair.of((Object)formatFrom, (Object)formatTo));
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    LightUtil.unpack(quad.getVertexData(), data, quad.getFormat(), v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static int[] mapFormats(VertexFormat from, VertexFormat to) {
        int fromCount = from.getElementCount();
        int toCount = to.getElementCount();
        int[] eMap = new int[fromCount];
        for (int e = 0; e < fromCount; ++e) {
            int e2;
            VertexFormatElement expected = from.getElement(e);
            for (e2 = 0; e2 < toCount; ++e2) {
                VertexFormatElement current = to.getElement(e2);
                if (expected.getUsage() == current.getUsage() && expected.getIndex() == current.getIndex()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }

    public static void unpack(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
        int length = 4 < to.length ? 4 : to.length;
        VertexFormatElement element = formatFrom.getElement(e);
        int vertexStart = v * formatFrom.getNextOffset() + formatFrom.getOffset(e);
        int count = element.getElementCount();
        VertexFormatElement.EnumType type = element.getType();
        int size = type.getSize();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == VertexFormatElement.EnumType.FLOAT) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == VertexFormatElement.EnumType.UBYTE || type == VertexFormatElement.EnumType.USHORT) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == VertexFormatElement.EnumType.UINT) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == VertexFormatElement.EnumType.BYTE) {
                    to[i] = (float)((byte)bits) / (float)mask * 2.0f;
                    continue;
                }
                if (type == VertexFormatElement.EnumType.SHORT) {
                    to[i] = (float)((short)bits) / (float)mask * 2.0f;
                    continue;
                }
                if (type != VertexFormatElement.EnumType.INT) continue;
                to[i] = (float)((long)bits & 0xFFFFFFFFL) / 4.2949673E9f * 2.0f;
                continue;
            }
            to[i] = 0.0f;
        }
    }

    public static void pack(float[] from, int[] to, VertexFormat formatTo, int v, int e) {
        VertexFormatElement element = formatTo.getElement(e);
        int vertexStart = v * formatTo.getNextOffset() + formatTo.getOffset(e);
        int count = element.getElementCount();
        VertexFormatElement.EnumType type = element.getType();
        int size = type.getSize();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < 4; ++i) {
            float f;
            if (i >= count) continue;
            int pos = vertexStart + size * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i < from.length ? from[i] : 0.0f;
            bits = type == VertexFormatElement.EnumType.FLOAT ? Float.floatToRawIntBits(f) : (type == VertexFormatElement.EnumType.UBYTE || type == VertexFormatElement.EnumType.USHORT || type == VertexFormatElement.EnumType.UINT ? (int)(f * (float)mask) : (int)(f * (float)mask / 2.0f));
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    public static IVertexConsumer getTessellator() {
        if (tessellator == null) {
            Tessellator tes = Tessellator.getInstance();
            VertexBuffer wr = tes.getBuffer();
            tessellator = new VertexBufferConsumer(wr);
        }
        return tessellator;
    }

    public static ItemConsumer getItemConsumer() {
        if (itemConsumer == null) {
            itemConsumer = new ItemConsumer(LightUtil.getTessellator());
        }
        return itemConsumer;
    }

    public static void renderQuadColorSlow(VertexBuffer wr, BakedQuad quad, int auxColor) {
        ItemConsumer cons = wr == Tessellator.getInstance().getBuffer() ? LightUtil.getItemConsumer() : new ItemConsumer(new VertexBufferConsumer(wr));
        float b = (float)(auxColor & 0xFF) / 255.0f;
        float g = (float)(auxColor >>> 8 & 0xFF) / 255.0f;
        float r = (float)(auxColor >>> 16 & 0xFF) / 255.0f;
        float a = (float)(auxColor >>> 24 & 0xFF) / 255.0f;
        cons.setAuxColor(r, g, b, a);
        quad.pipe(cons);
    }

    public static void renderQuadColor(VertexBuffer wr, BakedQuad quad, int auxColor) {
        wr.addVertexData(quad.getVertexData());
        ForgeHooksClient.putQuadColor(wr, quad, auxColor);
    }

    public static class ItemConsumer
    extends VertexTransformer {
        private int vertices = 0;
        private float[] auxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private float[] buf = new float[4];

        public ItemConsumer(IVertexConsumer parent) {
            super(parent);
        }

        public void setAuxColor(float ... auxColor) {
            System.arraycopy(auxColor, 0, this.auxColor, 0, this.auxColor.length);
        }

        @Override
        public void put(int element, float ... data) {
            if (this.getVertexFormat().getElement(element).getUsage() == VertexFormatElement.EnumUsage.COLOR) {
                System.arraycopy(this.auxColor, 0, this.buf, 0, this.buf.length);
                for (int i = 0; i < 4; ++i) {
                    int n = i;
                    this.buf[n] = this.buf[n] * data[i];
                }
                super.put(element, this.buf);
            } else {
                super.put(element, data);
            }
            if (element == this.getVertexFormat().getElementCount() - 1) {
                ++this.vertices;
                if (this.vertices == 4) {
                    this.vertices = 0;
                }
            }
        }
    }
}

