/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public abstract class QuadGatheringTransformer
implements IVertexConsumer {
    protected IVertexConsumer parent;
    protected VertexFormat format;
    protected int vertices = 0;
    protected byte[] dataLength = null;
    protected float[][][] quadData = null;

    public void setParent(IVertexConsumer parent) {
        this.parent = parent;
    }

    public void setVertexFormat(VertexFormat format) {
        this.format = format;
        this.dataLength = new byte[format.getElementCount()];
        this.quadData = new float[format.getElementCount()][4][4];
    }

    @Override
    public VertexFormat getVertexFormat() {
        return this.format;
    }

    @Override
    public void put(int element, float ... data) {
        System.arraycopy(data, 0, this.quadData[element][this.vertices], 0, data.length);
        if (element == this.getVertexFormat().getElementCount() - 1) {
            ++this.vertices;
        }
        if (this.vertices == 0) {
            this.dataLength[element] = (byte)data.length;
        } else if (this.vertices == 4) {
            this.vertices = 0;
            this.processQuad();
        }
    }

    protected abstract void processQuad();
}

