/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class VertexBufferConsumer
implements IVertexConsumer {
    private static final float[] dummyColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final VertexBuffer renderer;
    private final int[] quadData;
    private int v = 0;
    private BlockPos offset = BlockPos.ORIGIN;

    public VertexBufferConsumer(VertexBuffer renderer) {
        this.renderer = renderer;
        this.quadData = new int[renderer.getVertexFormat().getNextOffset()];
    }

    @Override
    public VertexFormat getVertexFormat() {
        return this.renderer.getVertexFormat();
    }

    @Override
    public void put(int e, float ... data) {
        VertexFormat format = this.getVertexFormat();
        if (this.renderer.isColorDisabled() && format.getElement(e).getUsage() == VertexFormatElement.EnumUsage.COLOR) {
            data = dummyColor;
        }
        LightUtil.pack(data, this.quadData, format, this.v, e);
        if (e == format.getElementCount() - 1) {
            ++this.v;
            if (this.v == 4) {
                this.renderer.addVertexData(this.quadData);
                this.renderer.putPosition(this.offset.getX(), this.offset.getY(), this.offset.getZ());
                this.v = 0;
            }
        }
    }

    public void setOffset(BlockPos offset) {
        this.offset = new BlockPos(offset);
    }

    @Override
    public void setQuadTint(int tint) {
    }

    @Override
    public void setQuadOrientation(EnumFacing orientation) {
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
    }

    @Override
    public void setTexture(TextureAtlasSprite texture) {
    }
}

