/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeDictionary {
    private static final Map<ResourceLocation, BiomeInfo> biomeInfoMap = new HashMap<ResourceLocation, BiomeInfo>();

    public static void addTypes(Biome biome, Type ... types) {
        Preconditions.checkArgument((boolean)ForgeRegistries.BIOMES.containsValue(biome), (String)"Cannot add types to unregistered biome %s", (Object[])new Object[]{biome});
        Collection<Type> supertypes = BiomeDictionary.listSupertypes(types);
        for (Type type : supertypes) {
            type.biomes.add(biome);
        }
        BiomeInfo biomeInfo = BiomeDictionary.getBiomeInfo(biome);
        Collections.addAll(biomeInfo.types, types);
        biomeInfo.types.addAll(supertypes);
    }

    @Nonnull
    public static Set<Biome> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(Biome biome) {
        BiomeDictionary.ensureHasTypes(biome);
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(Biome biomeA, Biome biomeB) {
        for (Type type : BiomeDictionary.getTypes(biomeA)) {
            if (!BiomeDictionary.getTypes(biomeB).contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(Biome biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(Biome biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    public static void makeBestGuess(Biome biome) {
        if (biome.theBiomeDecorator.treesPerChunk >= 3) {
            if (biome.isHighHumidity() && biome.getTemperature() >= 0.9f) {
                BiomeDictionary.addTypes(biome, Type.JUNGLE);
            } else if (!biome.isHighHumidity()) {
                BiomeDictionary.addTypes(biome, Type.FOREST);
                if (biome.getTemperature() <= 0.2f) {
                    BiomeDictionary.addTypes(biome, Type.CONIFEROUS);
                }
            }
        } else if (biome.getHeightVariation() <= 0.3f && biome.getHeightVariation() >= 0.0f && (!biome.isHighHumidity() || biome.getBaseHeight() >= 0.0f)) {
            BiomeDictionary.addTypes(biome, Type.PLAINS);
        }
        if (biome.getRainfall() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.WET);
        }
        if (biome.getRainfall() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.DRY);
        }
        if (biome.getTemperature() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.HOT);
        }
        if (biome.getTemperature() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.COLD);
        }
        if (biome.theBiomeDecorator.treesPerChunk > 0 && biome.theBiomeDecorator.treesPerChunk < 3) {
            BiomeDictionary.addTypes(biome, Type.SPARSE);
        } else if (biome.theBiomeDecorator.treesPerChunk >= 10) {
            BiomeDictionary.addTypes(biome, Type.DENSE);
        }
        if (biome.isHighHumidity() && biome.getBaseHeight() < 0.0f && biome.getHeightVariation() <= 0.3f && biome.getHeightVariation() >= 0.0f) {
            BiomeDictionary.addTypes(biome, Type.SWAMP);
        }
        if (biome.getBaseHeight() <= -0.5f) {
            if (biome.getHeightVariation() == 0.0f) {
                BiomeDictionary.addTypes(biome, Type.RIVER);
            } else {
                BiomeDictionary.addTypes(biome, Type.OCEAN);
            }
        }
        if (biome.getHeightVariation() >= 0.4f && biome.getHeightVariation() < 1.5f) {
            BiomeDictionary.addTypes(biome, Type.HILLS);
        }
        if (biome.getHeightVariation() >= 1.5f) {
            BiomeDictionary.addTypes(biome, Type.MOUNTAIN);
        }
        if (biome.getEnableSnow()) {
            BiomeDictionary.addTypes(biome, Type.SNOWY);
        }
        if (biome.topBlock != Blocks.SAND && biome.getTemperature() >= 1.0f && biome.getRainfall() < 0.2f) {
            BiomeDictionary.addTypes(biome, Type.SAVANNA);
        }
        if (biome.topBlock == Blocks.SAND) {
            BiomeDictionary.addTypes(biome, Type.SANDY);
        } else if (biome.topBlock == Blocks.MYCELIUM) {
            BiomeDictionary.addTypes(biome, Type.MUSHROOM);
        }
        if (biome.fillerBlock == Blocks.HARDENED_CLAY) {
            BiomeDictionary.addTypes(biome, Type.MESA);
        }
    }

    private static BiomeInfo getBiomeInfo(Biome biome) {
        BiomeInfo info = biomeInfoMap.get(biome.getRegistryName());
        if (info == null) {
            info = new BiomeInfo();
            biomeInfoMap.put(biome.getRegistryName(), info);
        }
        return info;
    }

    static void ensureHasTypes(Biome biome) {
        if (!BiomeDictionary.hasAnyType(biome)) {
            BiomeDictionary.makeBestGuess(biome);
            FMLLog.warning("No types have been added to Biome %s, types have been assigned on a best-effort guess: %s", biome.getRegistryName(), BiomeDictionary.getTypes(biome));
        }
    }

    private static Collection<Type> listSupertypes(Type ... types) {
        HashSet<Type> supertypes = new HashSet<Type>();
        ArrayDeque<Type> next = new ArrayDeque<Type>();
        Collections.addAll(next, types);
        while (!next.isEmpty()) {
            Type type = (Type)next.remove();
            for (Type sType : Type.byName.values()) {
                if (!type.subTypes.contains(type) || !supertypes.add(sType)) continue;
                next.add(sType);
            }
        }
        return supertypes;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes(Biomes.OCEAN, Type.OCEAN);
        BiomeDictionary.addTypes(Biomes.PLAINS, Type.PLAINS);
        BiomeDictionary.addTypes(Biomes.DESERT, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.addTypes(Biomes.EXTREME_HILLS, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.FOREST, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.TAIGA, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.SWAMPLAND, Type.WET, Type.SWAMP);
        BiomeDictionary.addTypes(Biomes.RIVER, Type.RIVER);
        BiomeDictionary.addTypes(Biomes.HELL, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes(Biomes.SKY, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes(Biomes.FROZEN_OCEAN, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.FROZEN_RIVER, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.ICE_PLAINS, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.addTypes(Biomes.ICE_MOUNTAINS, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.addTypes(Biomes.MUSHROOM_ISLAND, Type.MUSHROOM, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUSHROOM_ISLAND_SHORE, Type.MUSHROOM, Type.BEACH, Type.RARE);
        BiomeDictionary.addTypes(Biomes.BEACH, Type.BEACH);
        BiomeDictionary.addTypes(Biomes.DESERT_HILLS, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.FOREST_HILLS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.TAIGA_HILLS, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.EXTREME_HILLS_EDGE, Type.MOUNTAIN);
        BiomeDictionary.addTypes(Biomes.JUNGLE, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.addTypes(Biomes.JUNGLE_HILLS, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.JUNGLE_EDGE, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(Biomes.DEEP_OCEAN, Type.OCEAN);
        BiomeDictionary.addTypes(Biomes.STONE_BEACH, Type.BEACH);
        BiomeDictionary.addTypes(Biomes.COLD_BEACH, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.BIRCH_FOREST, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.BIRCH_FOREST_HILLS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.ROOFED_FOREST, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.COLD_TAIGA, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.COLD_TAIGA_HILLS, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.REDWOOD_TAIGA, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.REDWOOD_TAIGA_HILLS, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.EXTREME_HILLS_WITH_TREES, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.addTypes(Biomes.SAVANNA, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.addTypes(Biomes.SAVANNA_PLATEAU, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MESA, Type.MESA, Type.SANDY);
        BiomeDictionary.addTypes(Biomes.MESA_ROCK, Type.MESA, Type.SPARSE, Type.SANDY);
        BiomeDictionary.addTypes(Biomes.MESA_CLEAR_ROCK, Type.MESA, Type.SANDY);
        BiomeDictionary.addTypes(Biomes.VOID, Type.VOID);
        BiomeDictionary.addTypes(Biomes.MUTATED_PLAINS, Type.PLAINS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_DESERT, Type.HOT, Type.DRY, Type.SANDY, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_EXTREME_HILLS, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_FOREST, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_TAIGA, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_SWAMPLAND, Type.WET, Type.SWAMP, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_ICE_FLATS, Type.COLD, Type.SNOWY, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_JUNGLE, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_JUNGLE_EDGE, Type.HOT, Type.SPARSE, Type.JUNGLE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_BIRCH_FOREST, Type.FOREST, Type.DENSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_BIRCH_FOREST_HILLS, Type.FOREST, Type.DENSE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_ROOFED_FOREST, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_TAIGA_COLD, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_REDWOOD_TAIGA, Type.DENSE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_REDWOOD_TAIGA_HILLS, Type.DENSE, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_EXTREME_HILLS_WITH_TREES, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_SAVANNA, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_SAVANNA_ROCK, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_MESA, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_MESA_ROCK, Type.HOT, Type.DRY, Type.SPARSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.MUTATED_MESA_CLEAR_ROCK, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }

    public static final class Type {
        private static final Map<String, Type> byName = new HashMap<String, Type>();
        public static final Type HOT = new Type("HOT", new Type[0]);
        public static final Type COLD = new Type("COLD", new Type[0]);
        public static final Type SPARSE = new Type("SPARSE", new Type[0]);
        public static final Type DENSE = new Type("DENSE", new Type[0]);
        public static final Type WET = new Type("WET", new Type[0]);
        public static final Type DRY = new Type("DRY", new Type[0]);
        public static final Type SAVANNA = new Type("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = new Type("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = new Type("JUNGLE", new Type[0]);
        public static final Type SPOOKY = new Type("SPOOKY", new Type[0]);
        public static final Type DEAD = new Type("DEAD", new Type[0]);
        public static final Type LUSH = new Type("LUSH", new Type[0]);
        public static final Type NETHER = new Type("NETHER", new Type[0]);
        public static final Type END = new Type("END", new Type[0]);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = new Type("MAGICAL", new Type[0]);
        public static final Type RARE = new Type("RARE", new Type[0]);
        public static final Type OCEAN = new Type("OCEAN", new Type[0]);
        public static final Type RIVER = new Type("RIVER", new Type[0]);
        public static final Type WATER = new Type("WATER", OCEAN, RIVER);
        public static final Type MESA = new Type("MESA", new Type[0]);
        public static final Type FOREST = new Type("FOREST", new Type[0]);
        public static final Type PLAINS = new Type("PLAINS", new Type[0]);
        public static final Type MOUNTAIN = new Type("MOUNTAIN", new Type[0]);
        public static final Type HILLS = new Type("HILLS", new Type[0]);
        public static final Type SWAMP = new Type("SWAMP", new Type[0]);
        public static final Type SANDY = new Type("SANDY", new Type[0]);
        public static final Type SNOWY = new Type("SNOWY", new Type[0]);
        public static final Type WASTELAND = new Type("WASTELAND", new Type[0]);
        public static final Type BEACH = new Type("BEACH", new Type[0]);
        public static final Type VOID = new Type("VOID", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<Biome> biomes = new HashSet<Biome>();
        private final Set<Biome> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
            byName.put(name, this);
        }

        private boolean hasSubTypes() {
            return !this.subTypes.isEmpty();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(String name, Type ... subTypes) {
            Type t = byName.get(name = name.toUpperCase());
            if (t == null) {
                t = new Type(name, subTypes);
            }
            return t;
        }
    }
}

