/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class DimensionManager {
    private static Hashtable<Integer, WorldServer> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, DimensionType> dimensions = new Hashtable();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<World, World> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static int[] getDimensions(DimensionType type) {
        int[] ret = new int[dimensions.size()];
        int x = 0;
        for (Map.Entry<Integer, DimensionType> ent : dimensions.entrySet()) {
            if (ent.getValue() != type) continue;
            ret[x++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerDimension(0, DimensionType.OVERWORLD);
        DimensionManager.registerDimension(-1, DimensionType.NETHER);
        DimensionManager.registerDimension(1, DimensionType.THE_END);
    }

    public static void registerDimension(int id, DimensionType type) {
        DimensionType.getById(type.getId());
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, type);
        if (id >= 0) {
            dimensionMap.set(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static DimensionType getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static WorldProvider getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).provider;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            ListIterator li = allWorlds.listIterator();
            while (li.hasNext()) {
                World w = (World)li.next();
                leakedWorlds.add((Object)System.identityHashCode(w));
            }
            for (World w : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w));
                if (leakCount == 5) {
                    FMLLog.fine("The world %x (%s) may have leaked: first encounter (5 occurrences).\n", System.identityHashCode(w), w.getWorldInfo().getWorldName());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.fine("The world %x (%s) may have leaked: seen %d times.\n", System.identityHashCode(w), w.getWorldInfo().getWorldName(), leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id, @Nullable WorldServer world, MinecraftServer server) {
        if (world != null) {
            worlds.put(id, world);
            weakWorldMap.put(world, world);
            server.worldTickTimes.put(id, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id, world.getWorldInfo().getWorldName(), world.getMinecraftServer());
        } else {
            worlds.remove(id);
            server.worldTickTimes.remove(id);
            FMLLog.info("Unloading dimension %d", id);
        }
        ArrayList<WorldServer> tmp = new ArrayList<WorldServer>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, WorldServer> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        server.worlds = tmp.toArray(new WorldServer[tmp.size()]);
    }

    public static void initDimension(int dim) {
        WorldServer overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.getMinecraftServer();
        ISaveHandler savehandler = overworld.getSaveHandler();
        WorldServer world = dim == 0 ? overworld : (WorldServer)new WorldServerMulti(mcServer, savehandler, dim, overworld, mcServer.theProfiler).init();
        world.addEventListener(new ServerWorldEventHandler(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        if (!mcServer.isSinglePlayer()) {
            world.getWorldInfo().setGameType(mcServer.getGameType());
        }
        mcServer.setDifficultyForAllWorlds(mcServer.getDifficulty());
    }

    public static WorldServer getWorld(int id) {
        return worlds.get(id);
    }

    public static WorldServer[] getWorlds() {
        return worlds.values().toArray(new WorldServer[worlds.size()]);
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static WorldProvider createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                WorldProvider ret = DimensionManager.getProviderType(dim).createDimension();
                ret.setDimension(dim);
                return ret;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.ERROR, String.format("An error occurred trying to create an instance of WorldProvider %d (%s)", new Object[]{dim, DimensionManager.getProviderType(dim)}), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void unloadWorld(int id) {
        unloadQueue.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id : unloadQueue) {
            WorldServer w = worlds.get(id);
            try {
                if (w != null) {
                    w.saveAllChunks(true, null);
                    continue;
                }
                FMLLog.warning("Unexpected world unload - world %d is already unloaded", id);
            }
            catch (MinecraftException e) {
                e.printStackTrace();
            }
            finally {
                if (w == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(w));
                w.flush();
                DimensionManager.setWorld(id, null, w.getMinecraftServer());
            }
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static NBTTagCompound saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        NBTTagCompound dimMap = new NBTTagCompound();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j = 0; j < 32; ++j) {
                val |= dimensionMap.get(i * 32 + j) ? 1 << j : 0;
            }
            data[i] = val;
        }
        dimMap.setIntArray("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(@Nullable NBTTagCompound compoundTag) {
        dimensionMap.clear();
        if (compoundTag == null) {
            for (Integer id : dimensions.keySet()) {
                if (id < 0) continue;
                dimensionMap.set(id);
            }
        } else {
            int[] intArray = compoundTag.getIntArray("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j = 0; j < 32; ++j) {
                    dimensionMap.set(i * 32 + j, (intArray[i] & 1 << j) != 0);
                }
            }
        }
    }

    @Nullable
    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return DimensionManager.getWorld(0).getSaveHandler().getWorldDirectory();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }
}

