/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHooks {
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN;
    private static ThreadLocal<EntityPlayer> craftingPlayer;
    private static ThreadLocal<Deque<LootTableContext>> lootContext;

    @Nonnull
    public static ItemStack getGrassSeed(Random rand, int fortune) {
        SeedEntry entry = WeightedRandom.getRandomItem(rand, seedList);
        if (entry == null || entry.seed.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return entry.getStack(rand, fortune);
    }

    public static boolean canHarvestBlock(@Nonnull Block block, @Nonnull EntityPlayer player, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if ((state = state.getBlock().getActualState(state, world, pos)).getMaterial().isToolNotRequired()) {
            return true;
        }
        ItemStack stack = player.getHeldItemMainhand();
        String tool = block.getHarvestTool(state);
        if (stack.isEmpty() || tool == null) {
            return player.canHarvestBlock(state);
        }
        int toolLevel = stack.getItem().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.canHarvestBlock(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean canToolHarvestBlock(IBlockAccess world, BlockPos pos, @Nonnull ItemStack stack) {
        IBlockState state = world.getBlockState(pos);
        state = state.getBlock().getActualState(state, world, pos);
        String tool = state.getBlock().getHarvestTool(state);
        if (stack.isEmpty() || tool == null) {
            return false;
        }
        return stack.getItem().getHarvestLevel(stack, tool, null, null) >= state.getBlock().getHarvestLevel(state);
    }

    public static float blockStrength(@Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        float hardness = state.getBlockHardness(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(state.getBlock(), player, world, pos)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    public static boolean isToolEffective(IBlockAccess world, BlockPos pos, @Nonnull ItemStack stack) {
        IBlockState state = world.getBlockState(pos);
        state = state.getBlock().getActualState(state, world, pos);
        for (String type : stack.getItem().getToolClasses(stack)) {
            if (!state.getBlock().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        Block[] oreBlocks;
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ReflectionHelper.getPrivateValue(ItemPickaxe.class, null, 0);
        for (Block block : blocks) {
            block.setHarvestLevel("pickaxe", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(ItemSpade.class, null, 0);
        for (Block block : blocks) {
            block.setHarvestLevel("shovel", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(ItemAxe.class, null, 0);
        for (Block block : blocks) {
            block.setHarvestLevel("axe", 0);
        }
        Blocks.OBSIDIAN.setHarvestLevel("pickaxe", 3);
        Blocks.ENCHANTING_TABLE.setHarvestLevel("pickaxe", 0);
        for (Block block : oreBlocks = new Block[]{Blocks.EMERALD_ORE, Blocks.EMERALD_BLOCK, Blocks.DIAMOND_ORE, Blocks.DIAMOND_BLOCK, Blocks.GOLD_ORE, Blocks.GOLD_BLOCK, Blocks.REDSTONE_ORE, Blocks.LIT_REDSTONE_ORE}) {
            block.setHarvestLevel("pickaxe", 2);
        }
        Blocks.IRON_ORE.setHarvestLevel("pickaxe", 1);
        Blocks.IRON_BLOCK.setHarvestLevel("pickaxe", 1);
        Blocks.LAPIS_ORE.setHarvestLevel("pickaxe", 1);
        Blocks.LAPIS_BLOCK.setHarvestLevel("pickaxe", 1);
        Blocks.QUARTZ_ORE.setHarvestLevel("pickaxe", 0);
    }

    public static int getTotalArmorValue(EntityPlayer player) {
        int ret = 0;
        for (int x = 0; x < player.inventory.armorInventory.size(); ++x) {
            ItemStack stack = player.inventory.armorInventory.get(x);
            if (stack.getItem() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)((Object)stack.getItem())).getArmorDisplay(player, stack, x);
                continue;
            }
            if (!(stack.getItem() instanceof ItemArmor)) continue;
            ret += ((ItemArmor)stack.getItem()).damageReduceAmount;
        }
        return ret;
    }

    public static boolean onPickBlock(RayTraceResult target, EntityPlayer player, World world) {
        ItemStack result;
        boolean isCreative = player.capabilities.isCreativeMode;
        TileEntity te = null;
        if (target.typeOfHit == RayTraceResult.Type.BLOCK) {
            IBlockState state = world.getBlockState(target.getBlockPos());
            if (state.getBlock().isAir(state, world, target.getBlockPos())) {
                return false;
            }
            if (isCreative && GuiScreen.isCtrlKeyDown() && state.getBlock().hasTileEntity(state)) {
                te = world.getTileEntity(target.getBlockPos());
            }
            result = state.getBlock().getPickBlock(state, target, world, target.getBlockPos(), player);
        } else {
            if (target.typeOfHit != RayTraceResult.Type.ENTITY || target.entityHit == null || !isCreative) {
                return false;
            }
            result = target.entityHit.getPickedResult(target);
        }
        if (result.isEmpty()) {
            return false;
        }
        if (te != null) {
            Minecraft.getMinecraft().storeTEInStack(result, te);
        }
        if (isCreative) {
            player.inventory.setPickedItemStack(result);
            Minecraft.getMinecraft().playerController.sendSlotPacket(player.getHeldItem(EnumHand.MAIN_HAND), 36 + player.inventory.currentItem);
            return true;
        }
        int slot = player.inventory.getSlotFor(result);
        if (slot != -1) {
            if (InventoryPlayer.isHotbar(slot)) {
                player.inventory.currentItem = slot;
            } else {
                Minecraft.getMinecraft().playerController.pickItem(slot);
            }
            return true;
        }
        return false;
    }

    public static void onLivingSetAttackTarget(EntityLivingBase entity, EntityLivingBase target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(EntityLivingBase entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(EntityLivingBase entity, DamageSource src, float amount) {
        return !MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(EntityLivingBase entity, DamageSource src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(EntityLivingBase entity, DamageSource src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(EntityLivingBase entity, DamageSource source, ArrayList<EntityItem> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    @Nullable
    public static float[] onLivingFall(EntityLivingBase entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static int getLootingLevel(Entity target, @Nullable Entity killer, DamageSource cause) {
        int looting = 0;
        if (killer instanceof EntityLivingBase) {
            looting = EnchantmentHelper.getLootingModifier((EntityLivingBase)killer);
        }
        if (target instanceof EntityLivingBase) {
            looting = ForgeHooks.getLootingLevel((EntityLivingBase)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(EntityLivingBase target, DamageSource cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getLootingLevel();
    }

    public static double getPlayerVisibilityDistance(EntityPlayer player, double xzDistance, double maxXZDistance) {
        PlayerEvent.Visibility event = new PlayerEvent.Visibility(player);
        MinecraftForge.EVENT_BUS.post(event);
        double value = event.getVisibilityModifier() * xzDistance;
        return value >= maxXZDistance ? maxXZDistance : value;
    }

    public static boolean isLivingOnLadder(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof EntityPlayer && ((EntityPlayer)entity).isSpectator();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return state.getBlock().isLadder(state, world, pos, entity);
        }
        AxisAlignedBB bb = entity.getEntityBoundingBox();
        int mX = MathHelper.floor(bb.minX);
        int mY = MathHelper.floor(bb.minY);
        int mZ = MathHelper.floor(bb.minZ);
        int y2 = mY;
        while ((double)y2 < bb.maxY) {
            int x2 = mX;
            while ((double)x2 < bb.maxX) {
                int z2 = mZ;
                while ((double)z2 < bb.maxZ) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    state = world.getBlockState(tmp);
                    if (state.getBlock().isLadder(state, world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(EntityLivingBase entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static EntityItem onPlayerTossEvent(@Nonnull EntityPlayer player, @Nonnull ItemStack item, boolean includeName) {
        player.captureDrops = true;
        EntityItem ret = player.dropItem(item, false, includeName);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        if (!player.world.isRemote) {
            player.getEntityWorld().spawnEntity(event.getEntityItem());
        }
        return event.getEntityItem();
    }

    public static float getEnchantPower(@Nonnull World world, @Nonnull BlockPos pos) {
        return world.getBlockState(pos).getBlock().getEnchantPowerBonus(world, pos);
    }

    @Nullable
    public static ITextComponent onServerChatEvent(NetHandlerPlayServer net, String raw, ITextComponent comp) {
        ServerChatEvent event = new ServerChatEvent(net.playerEntity, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getComponent();
    }

    public static ITextComponent newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static ITextComponent newChatWithLinks(String string, boolean allowMissingHeader) {
        TextComponentString ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            TextComponentString link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new TextComponentString(part);
                    } else {
                        ichat.appendText(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new TextComponentString(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new TextComponentString(url);
                            continue;
                        }
                        ichat.appendText(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new TextComponentString(url);
                        continue;
                    }
                    ichat.appendText(url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
            link.getStyle().setClickEvent(click);
            link.getStyle().setUnderlined(true);
            link.getStyle().setColor(TextFormatting.BLUE);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.appendSibling(link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new TextComponentString(end);
        } else if (end.length() > 0) {
            ichat.appendText(string.substring(lastEnd));
        }
        return ichat;
    }

    public static int onBlockBreakEvent(World world, GameType gameType, EntityPlayerMP entityPlayer, BlockPos pos) {
        boolean preCancelEvent = false;
        if (gameType.isCreative() && !entityPlayer.getHeldItemMainhand().isEmpty() && entityPlayer.getHeldItemMainhand().getItem() instanceof ItemSword) {
            preCancelEvent = true;
        }
        if (gameType.isAdventure()) {
            ItemStack itemstack;
            if (gameType == GameType.SPECTATOR) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.isAllowEdit() || !(itemstack = entityPlayer.getHeldItemMainhand()).isEmpty() && itemstack.canDestroy(world.getBlockState(pos).getBlock()))) {
                preCancelEvent = true;
            }
        }
        if (world.getTileEntity(pos) == null) {
            SPacketBlockChange packet = new SPacketBlockChange(world, pos);
            packet.blockState = Blocks.AIR.getDefaultState();
            entityPlayer.connection.sendPacket(packet);
        }
        IBlockState state = world.getBlockState(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled()) {
            SPacketUpdateTileEntity pkt;
            entityPlayer.connection.sendPacket(new SPacketBlockChange(world, pos));
            TileEntity tileentity = world.getTileEntity(pos);
            if (tileentity != null && (pkt = tileentity.getUpdatePacket()) != null) {
                entityPlayer.connection.sendPacket(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static EnumActionResult onPlaceItemIntoWorld(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        int meta = itemstack.getItemDamage();
        int size = itemstack.getCount();
        NBTTagCompound nbt = null;
        if (itemstack.getTagCompound() != null) {
            nbt = itemstack.getTagCompound().copy();
        }
        if (!(itemstack.getItem() instanceof ItemBucket)) {
            world.captureBlockSnapshots = true;
        }
        EnumActionResult ret = itemstack.getItem().onItemUse(player, world, pos, hand, side, hitX, hitY, hitZ);
        world.captureBlockSnapshots = false;
        if (ret == EnumActionResult.SUCCESS) {
            int newMeta = itemstack.getItemDamage();
            int newSize = itemstack.getCount();
            NBTTagCompound newNBT = null;
            if (itemstack.getTagCompound() != null) {
                newNBT = itemstack.getTagCompound().copy();
            }
            BlockEvent.PlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.setItemDamage(meta);
            itemstack.setCount(size);
            if (nbt != null) {
                itemstack.setTagCompound(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace(player, blockSnapshots, side, hand);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace(player, (BlockSnapshot)blockSnapshots.get(0), side, hand);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                ret = EnumActionResult.FAIL;
                for (BlockSnapshot blocksnapshot : blockSnapshots) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.setItemDamage(newMeta);
                itemstack.setCount(newSize);
                if (nbt != null) {
                    itemstack.setTagCompound(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    IBlockState oldBlock = snap.getReplacedBlock();
                    IBlockState newBlock = world.getBlockState(snap.getPos());
                    if (!newBlock.getBlock().hasTileEntity(newBlock)) {
                        newBlock.getBlock().onBlockAdded(world, snap.getPos(), newBlock);
                    }
                    world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                }
                player.addStat(StatList.getObjectUseStats(itemstack.getItem()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(ContainerRepair container, @Nonnull ItemStack left, @Nonnull ItemStack right, IInventory outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            return false;
        }
        if (e.getOutput().isEmpty()) {
            return true;
        }
        outputSlot.setInventorySlotContents(0, e.getOutput());
        container.maximumCost = e.getCost();
        container.materialCost = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(EntityPlayer player, @Nonnull ItemStack output, @Nonnull ItemStack left, @Nonnull ItemStack right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post(e);
        return e.getBreakChance();
    }

    public static boolean onNoteChange(TileEntityNote te, byte old) {
        NoteBlockEvent.Change e = new NoteBlockEvent.Change(te.getWorld(), te.getPos(), te.getWorld().getBlockState(te.getPos()), old, te.note);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            te.note = old;
            return false;
        }
        te.note = (byte)e.getVanillaNoteId();
        return true;
    }

    public static NonNullList<ItemStack> defaultRecipeGetRemainingItems(InventoryCrafting inv) {
        NonNullList<ItemStack> ret = NonNullList.withSize(inv.getSizeInventory(), ItemStack.EMPTY);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, ForgeHooks.getContainerItem(inv.getStackInSlot(i)));
        }
        return ret;
    }

    public static void setCraftingPlayer(EntityPlayer player) {
        craftingPlayer.set(player);
    }

    public static EntityPlayer getCraftingPlayer() {
        return craftingPlayer.get();
    }

    @Nonnull
    public static ItemStack getContainerItem(@Nonnull ItemStack stack) {
        if (stack.getItem().hasContainerItem(stack)) {
            if (!(stack = stack.getItem().getContainerItem(stack)).isEmpty() && stack.isItemStackDamageable() && stack.getMetadata() > stack.getMaxDamage()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return ItemStack.EMPTY;
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isInsideOfMaterial(Material material, Entity entity, BlockPos pos) {
        IBlockState state = entity.world.getBlockState(pos);
        Block block = state.getBlock();
        double eyes = entity.posY + (double)entity.getEyeHeight();
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)((Object)block)).getFilledPercentage(entity.world, pos);
        } else if (block instanceof BlockLiquid) {
            filled = BlockLiquid.getLiquidHeightPercent(block.getMetaFromState(state));
        }
        if (filled < 0.0) {
            return eyes > (double)(pos.getY() + 1) + (1.0 - (filled *= -1.0));
        }
        return eyes < (double)(pos.getY() + 1) + filled;
    }

    public static boolean onPlayerAttackTarget(EntityPlayer player, Entity target) {
        if (MinecraftForge.EVENT_BUS.post(new AttackEntityEvent(player, target))) {
            return false;
        }
        ItemStack stack = player.getHeldItemMainhand();
        return stack.isEmpty() || !stack.getItem().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(Entity entity, int dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && entity instanceof EntityMinecartContainer) {
            ((EntityMinecartContainer)entity).dropContentsWhenDead = true;
        }
        return !event.isCanceled();
    }

    @Nullable
    public static RayTraceResult rayTraceEyes(EntityLivingBase entity, double length) {
        Vec3d startPos = new Vec3d(entity.posX, entity.posY + (double)entity.getEyeHeight(), entity.posZ);
        Vec3d endPos = startPos.add(new Vec3d(entity.getLookVec().xCoord * length, entity.getLookVec().yCoord * length, entity.getLookVec().zCoord * length));
        return entity.world.rayTraceBlocks(startPos, endPos);
    }

    @Nullable
    public static Vec3d rayTraceEyeHitVec(EntityLivingBase entity, double length) {
        RayTraceResult git = ForgeHooks.rayTraceEyes(entity, length);
        return git == null ? null : git.hitVec;
    }

    public static boolean onInteractEntityAt(EntityPlayer player, Entity entity, RayTraceResult ray, EnumHand hand) {
        Vec3d vec3d = new Vec3d(ray.hitVec.xCoord - entity.posX, ray.hitVec.yCoord - entity.posY, ray.hitVec.zCoord - entity.posZ);
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    public static boolean onInteractEntityAt(EntityPlayer player, Entity entity, Vec3d vec3d, EnumHand hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteractSpecific(player, hand, entity, vec3d));
    }

    public static boolean onInteractEntity(EntityPlayer player, Entity entity, EnumHand hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteract(player, hand, entity));
    }

    public static boolean onItemRightClick(EntityPlayer player, EnumHand hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickItem(player, hand));
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(EntityPlayer player, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(EntityPlayer player, EnumHand hand, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void onEmptyClick(EntityPlayer player, EnumHand hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(EntityPlayer player) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.LeftClickEmpty(player));
    }

    @Deprecated
    public static void onEmptyLeftClick(EntityPlayer player, @Nonnull ItemStack stack) {
        ForgeHooks.onEmptyLeftClick(player);
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could to grab json context!");
        }
        return ctx;
    }

    @Nullable
    public static LootTable loadLootTable(Gson gson, ResourceLocation name, String data, boolean custom) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        LootTable ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (LootTable)gson.fromJson(data, LootTable.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret);
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return JsonUtils.getString(json, "name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(JsonUtils.getString(json, "entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = JsonUtils.getString(json, "name");
        } else if ("loot_table".equals(type)) {
            name = JsonUtils.getString(json, "name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static LootEntry deserializeJsonLootEntry(String type, JsonObject json, int weight, int quality, LootCondition[] conditions) {
        return null;
    }

    public static String getLootEntryType(LootEntry entry) {
        return null;
    }

    public static boolean onThrowableImpact(EntityThrowable throwable, RayTraceResult ray) {
        return MinecraftForge.EVENT_BUS.post(new ThrowableImpactEvent(throwable, ray));
    }

    public static boolean onCropsGrowPre(World worldIn, BlockPos pos, IBlockState state, boolean def) {
        BlockEvent.CropGrowEvent.Pre ev = new BlockEvent.CropGrowEvent.Pre(worldIn, pos, state);
        MinecraftForge.EVENT_BUS.post(ev);
        return ev.getResult() == Event.Result.ALLOW || ev.getResult() == Event.Result.DEFAULT && def;
    }

    public static void onCropsGrowPost(World worldIn, BlockPos pos, IBlockState state, IBlockState blockState) {
        MinecraftForge.EVENT_BUS.post(new BlockEvent.CropGrowEvent.Post(worldIn, pos, state, worldIn.getBlockState(pos)));
    }

    static {
        seedList.add(new SeedEntry(new ItemStack(Items.WHEAT_SEEDS), 10){

            @Override
            @Nonnull
            public ItemStack getStack(Random rand, int fortune) {
                return new ItemStack(Items.WHEAT_SEEDS, 1 + rand.nextInt(fortune * 2 + 1));
            }
        });
        ForgeHooks.initTools();
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
        craftingPlayer = new ThreadLocal();
        lootContext = new ThreadLocal();
    }

    private static class LootTableContext {
        public final ResourceLocation name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(ResourceLocation name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.getResourceDomain());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(@Nullable String name) {
            if (name != null && !this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x = 0;
            while (this.entryNames.contains(name + "#" + x)) {
                ++x;
            }
            name = name + "#" + x;
            this.entryNames.add(name);
            return name;
        }
    }

    static class SeedEntry
    extends WeightedRandom.Item {
        @Nonnull
        public final ItemStack seed;

        public SeedEntry(@Nonnull ItemStack seed, int weight) {
            super(weight);
            this.seed = seed;
        }

        @Nonnull
        public ItemStack getStack(Random rand, int fortune) {
            return this.seed.copy();
        }
    }
}

