/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class MinecraftForge {
    public static final EventBus EVENT_BUS = new EventBus();
    public static final EventBus TERRAIN_GEN_BUS = new EventBus();
    public static final EventBus ORE_GEN_BUS = new EventBus();
    public static final String MC_VERSION = "1.11.2";
    static final ForgeInternalHandler INTERNAL_HANDLER = new ForgeInternalHandler();

    public static void addGrassSeed(@Nonnull ItemStack seed, int weight) {
        MinecraftForge.addGrassSeed(new ForgeHooks.SeedEntry(seed, weight));
    }

    public static void addGrassSeed(ForgeHooks.SeedEntry seed) {
        ForgeHooks.seedList.add(seed);
    }

    public static void initialize() {
        FMLLog.info("MinecraftForge v%s Initialized", ForgeVersion.getVersion());
        OreDictionary.getOreName(0);
        UsernameCache.load();
        FluidRegistry.validateFluidRegistry();
        ForgeHooks.initTools();
        new CrashReport("ThisIsFake", new Exception("Not real"));
    }

    public static void preloadCrashClasses(ASMDataTable table, String modID, Set<String> classes) {
        ArrayList all = Lists.newArrayList();
        for (ASMDataTable.ASMData asm : table.getAll(ICrashReportDetail.class.getName().replace('.', '/'))) {
            all.add(asm.getClassName());
        }
        for (ASMDataTable.ASMData asm : table.getAll(ICrashCallable.class.getName().replace('.', '/'))) {
            all.add(asm.getClassName());
        }
        all.retainAll(classes);
        if (all.size() == 0) {
            return;
        }
        FMLLog.log(modID, Level.DEBUG, "Preloading CrashReport Classes", new Object[0]);
        Collections.sort(all);
        for (String name : all) {
            FMLLog.log(modID, Level.DEBUG, "\t" + name, new Object[0]);
            try {
                Class.forName(name.replace('/', '.'), false, MinecraftForge.class.getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

