/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AbstractBrewingRecipe<T>
implements IBrewingRecipe {
    @Nonnull
    private final ItemStack input;
    private final T ingredient;
    private final ItemStack output;

    protected AbstractBrewingRecipe(@Nonnull ItemStack input, @Nonnull T ingredient, @Nonnull ItemStack output) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
        if (this.getInput().getMaxStackSize() != 1) {
            throw new IllegalArgumentException("Inputs must have a max size of 1 just like water bottles. Brewing Stands override the input with the output when the brewing is done, items that stack would end up getting lost.");
        }
    }

    @Override
    public boolean isInput(@Nonnull ItemStack stack) {
        return OreDictionary.itemMatches(this.getInput(), stack, false);
    }

    @Override
    @Nonnull
    public ItemStack getOutput(@Nonnull ItemStack input, @Nonnull ItemStack ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.getOutput().copy() : ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack getInput() {
        return this.input;
    }

    @Nonnull
    public T getIngredient() {
        return this.ingredient;
    }

    @Nonnull
    public ItemStack getOutput() {
        return this.output;
    }
}

