/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;

public class Capability<T> {
    private final String name;
    private final IStorage<T> storage;
    private final Callable<? extends T> factory;

    public String getName() {
        return this.name;
    }

    public IStorage<T> getStorage() {
        return this.storage;
    }

    public void readNBT(T instance, EnumFacing side, NBTBase nbt) {
        this.storage.readNBT(this, instance, side, nbt);
    }

    @Nullable
    public NBTBase writeNBT(T instance, EnumFacing side) {
        return this.storage.writeNBT(this, instance, side);
    }

    @Nullable
    public T getDefaultInstance() {
        try {
            return this.factory.call();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public <R> R cast(T instance) {
        return (R)instance;
    }

    Capability(String name, IStorage<T> storage, Callable<? extends T> factory) {
        this.name = name;
        this.storage = storage;
        this.factory = factory;
    }

    public static interface IStorage<T> {
        @Nullable
        public NBTBase writeNBT(Capability<T> var1, T var2, EnumFacing var3);

        public void readNBT(Capability<T> var1, T var2, EnumFacing var3, NBTBase var4);
    }
}

