/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.Type;

public enum CapabilityManager {
    INSTANCE;

    private IdentityHashMap<String, Capability<?>> providers = Maps.newIdentityHashMap();
    private IdentityHashMap<String, List<Function<Capability<?>, Object>>> callbacks = Maps.newIdentityHashMap();

    public <T> void register(Class<T> type, Capability.IStorage<T> storage, final Class<? extends T> implementation) {
        Preconditions.checkArgument((implementation != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with no default implementation");
        this.register(type, storage, new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    return implementation.newInstance();
                }
                catch (InstantiationException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public <T> void register(Class<T> type, Capability.IStorage<T> storage, Callable<? extends T> factory) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with invalid type");
        Preconditions.checkArgument((storage != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with no storage implementation");
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with no default implementation factory");
        String realName = type.getName().intern();
        Preconditions.checkState((!this.providers.containsKey(realName) ? 1 : 0) != 0, (String)"Can not register a capability implementation multiple times: %s", (Object[])new Object[]{realName});
        Capability<? extends T> cap = new Capability<T>(realName, storage, factory);
        this.providers.put(realName, cap);
        List<Function<Capability<?>, Object>> list = this.callbacks.get(realName);
        if (list != null) {
            for (Function<Capability<?>, Object> func : list) {
                func.apply(cap);
            }
        }
    }

    public void injectCapabilities(ASMDataTable data) {
        for (ASMDataTable.ASMData entry : data.getAll(CapabilityInject.class.getName())) {
            final String targetClass = entry.getClassName();
            final String targetName = entry.getObjectName();
            Type type = (Type)entry.getAnnotationInfo().get("value");
            if (type == null) {
                FMLLog.log(Level.WARN, "Unable to inject capability at %s.%s (Invalid Annotation)", targetClass, targetName);
                continue;
            }
            final String capabilityName = type.getInternalName().replace('/', '.').intern();
            ArrayList list = this.callbacks.get(capabilityName);
            if (list == null) {
                list = Lists.newArrayList();
                this.callbacks.put(capabilityName, list);
            }
            if (entry.getObjectName().indexOf(40) > 0) {
                list.add(new Function<Capability<?>, Object>(){

                    public Object apply(Capability<?> input) {
                        try {
                            for (Method mtd : Class.forName(targetClass).getDeclaredMethods()) {
                                if (!targetName.equals(mtd.getName() + Type.getMethodDescriptor((Method)mtd))) continue;
                                if ((mtd.getModifiers() & 8) != 8) {
                                    FMLLog.log(Level.WARN, "Unable to inject capability %s at %s.%s (Non-Static)", capabilityName, targetClass, targetName);
                                    return null;
                                }
                                mtd.setAccessible(true);
                                mtd.invoke(null, input);
                                return null;
                            }
                            FMLLog.log(Level.WARN, "Unable to inject capability %s at %s.%s (Method Not Found)", capabilityName, targetClass, targetName);
                        }
                        catch (Exception e) {
                            FMLLog.log(Level.WARN, e, "Unable to inject capability %s at %s.%s", capabilityName, targetClass, targetName);
                        }
                        return null;
                    }
                });
                continue;
            }
            list.add(new Function<Capability<?>, Object>(){

                public Object apply(Capability<?> input) {
                    try {
                        Field field = Class.forName(targetClass).getDeclaredField(targetName);
                        if ((field.getModifiers() & 8) != 8) {
                            FMLLog.log(Level.WARN, "Unable to inject capability %s at %s.%s (Non-Static)", capabilityName, targetClass, targetName);
                            return null;
                        }
                        EnumHelper.setFailsafeFieldValue(field, null, input);
                    }
                    catch (Exception e) {
                        FMLLog.log(Level.WARN, e, "Unable to inject capability %s at %s.%s", capabilityName, targetClass, targetName);
                    }
                    return null;
                }
            });
        }
    }
}

