/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.io.Serializable;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final BlockPos pos;
    private final int dimId;
    private transient IBlockState replacedBlock;
    private int flag;
    @Nullable
    private final NBTTagCompound nbt;
    private transient World world;
    private final ResourceLocation registryName;
    private final int meta;

    public BlockSnapshot(World world, BlockPos pos, IBlockState state) {
        this.setWorld(world);
        this.dimId = world.provider.getDimension();
        this.pos = pos;
        this.setReplacedBlock(state);
        this.registryName = state.getBlock().getRegistryName();
        this.meta = state.getBlock().getMetaFromState(state);
        this.setFlag(3);
        TileEntity te = world.getTileEntity(pos);
        if (te != null) {
            this.nbt = new NBTTagCompound();
            te.writeToNBT(this.getNbt());
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.getWorldInfo().getWorldName(), pos.getX(), pos.getY(), pos.getZ(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(World world, BlockPos pos, IBlockState state, @Nullable NBTTagCompound nbt) {
        this.setWorld(world);
        this.dimId = world.provider.getDimension();
        this.pos = pos.toImmutable();
        this.setReplacedBlock(state);
        this.registryName = state.getBlock().getRegistryName();
        this.meta = state.getBlock().getMetaFromState(state);
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.getWorldInfo().getWorldName(), pos.getX(), pos.getY(), pos.getZ(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(World world, BlockPos pos, IBlockState state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    public BlockSnapshot(int dimension, BlockPos pos, String modId, String blockName, int meta, int flag, @Nullable NBTTagCompound nbt) {
        this.dimId = dimension;
        this.pos = pos.toImmutable();
        this.setFlag(flag);
        this.registryName = new ResourceLocation(modId, blockName);
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(World world, BlockPos pos) {
        return new BlockSnapshot(world, pos, world.getBlockState(pos));
    }

    public static BlockSnapshot getBlockSnapshot(World world, BlockPos pos, int flag) {
        return new BlockSnapshot(world, pos, world.getBlockState(pos), flag);
    }

    public static BlockSnapshot readFromNBT(NBTTagCompound tag) {
        NBTTagCompound nbt = tag.getBoolean("hasTE") ? null : tag.getCompoundTag("tileEntity");
        return new BlockSnapshot(tag.getInteger("dimension"), new BlockPos(tag.getInteger("posX"), tag.getInteger("posY"), tag.getInteger("posZ")), tag.getString("blockMod"), tag.getString("blockName"), tag.getInteger("metadata"), tag.getInteger("flag"), nbt);
    }

    public IBlockState getCurrentBlock() {
        return this.getWorld().getBlockState(this.getPos());
    }

    public World getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.getDimId());
        }
        return this.world;
    }

    public IBlockState getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = ForgeRegistries.BLOCKS.getValue(this.getRegistryName()).getStateFromMeta(this.getMeta());
        }
        return this.replacedBlock;
    }

    public TileEntity getTileEntity() {
        if (this.getNbt() != null) {
            return TileEntity.create(this.getWorld(), this.getNbt());
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        IBlockState current = this.getCurrentBlock();
        IBlockState replaced = this.getReplacedBlock();
        if (current.getBlock() != replaced.getBlock() || current.getBlock().getMetaFromState(current) != replaced.getBlock().getMetaFromState(replaced)) {
            if (force) {
                this.getWorld().setBlockState(this.getPos(), replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.getWorld().setBlockState(this.getPos(), replaced, applyPhysics ? 3 : 2);
        this.getWorld().notifyBlockUpdate(this.getPos(), current, replaced, applyPhysics ? 3 : 2);
        TileEntity te = null;
        if (this.getNbt() != null && (te = this.getWorld().getTileEntity(this.getPos())) != null) {
            te.readFromNBT(this.getNbt());
            te.markDirty();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.getWorld().getWorldInfo().getWorldName(), this.getPos().getX(), this.getPos().getY(), this.getPos().getZ(), replaced.getBlock().getMetaFromState(replaced), replaced.getBlock().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(World world, BlockPos pos, boolean force, boolean applyPhysics) {
        IBlockState current = this.getCurrentBlock();
        IBlockState replaced = this.getReplacedBlock();
        if (current.getBlock() != replaced.getBlock() || current.getBlock().getMetaFromState(current) != replaced.getBlock().getMetaFromState(replaced)) {
            if (force) {
                world.setBlockState(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.setBlockState(pos, replaced, applyPhysics ? 3 : 2);
        world.notifyBlockUpdate(pos, current, replaced, applyPhysics ? 3 : 2);
        TileEntity te = null;
        if (this.getNbt() != null && (te = world.getTileEntity(pos)) != null) {
            te.readFromNBT(this.getNbt());
            te.markDirty();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.getWorldInfo().getWorldName(), pos.getX(), pos.getY(), pos.getZ(), replaced.getBlock().getMetaFromState(replaced), replaced.getBlock().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.setString("blockMod", this.getRegistryName().getResourceDomain());
        compound.setString("blockName", this.getRegistryName().getResourcePath());
        compound.setInteger("posX", this.getPos().getX());
        compound.setInteger("posY", this.getPos().getY());
        compound.setInteger("posZ", this.getPos().getZ());
        compound.setInteger("flag", this.getFlag());
        compound.setInteger("dimension", this.getDimId());
        compound.setInteger("metadata", this.getMeta());
        compound.setBoolean("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.setTag("tileEntity", this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (!this.getPos().equals(other.getPos())) {
            return false;
        }
        if (this.getMeta() != other.getMeta()) {
            return false;
        }
        if (this.getDimId() != other.getDimId()) {
            return false;
        }
        if (!(this.getNbt() == other.getNbt() || this.getNbt() != null && this.getNbt().equals(other.getNbt()))) {
            return false;
        }
        if (!(this.getWorld() == other.getWorld() || this.getWorld() != null && this.getWorld().equals(other.getWorld()))) {
            return false;
        }
        return this.getRegistryName() == other.getRegistryName() || this.getRegistryName() != null && this.getRegistryName().equals(other.getRegistryName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getPos().getX();
        hash = 73 * hash + this.getPos().getY();
        hash = 73 * hash + this.getPos().getZ();
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + (this.getNbt() != null ? this.getNbt().hashCode() : 0);
        hash = 73 * hash + (this.getWorld() != null ? this.getWorld().hashCode() : 0);
        hash = 73 * hash + (this.getRegistryName() != null ? this.getRegistryName().hashCode() : 0);
        return hash;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(IBlockState replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    @Nullable
    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return this.meta;
    }
}

