/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.util.Comparator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.ChunkPos;

public class ChunkCoordComparator
implements Comparator<ChunkPos> {
    private int x;
    private int z;

    public ChunkCoordComparator(EntityPlayerMP entityplayer) {
        this.x = (int)entityplayer.posX >> 4;
        this.z = (int)entityplayer.posZ >> 4;
    }

    @Override
    public int compare(ChunkPos a, ChunkPos b) {
        if (a.equals(b)) {
            return 0;
        }
        int ax = a.chunkXPos - this.x;
        int bx = b.chunkXPos - this.x;
        int az = a.chunkZPos - this.z;
        int bz = b.chunkZPos - this.z;
        int result = (ax - bx) * (ax + bx) + (az - bz) * (az + bz);
        if (result != 0) {
            return result;
        }
        if (ax < 0) {
            if (bx < 0) {
                return bz - az;
            }
            return -1;
        }
        if (bx < 0) {
            return 1;
        }
        return az - bz;
    }
}

