/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLLog;

public class EnumHelper {
    private static Object reflectionFactory = null;
    private static Method newConstructorAccessor = null;
    private static Method newInstance = null;
    private static Method newFieldAccessor = null;
    private static Method fieldAccessorSet = null;
    private static boolean isSetup = false;
    private static Class<?>[][] commonTypes = new Class[][]{{EnumAction.class}, {ItemArmor.ArmorMaterial.class, String.class, Integer.TYPE, int[].class, Integer.TYPE, SoundEvent.class, Float.TYPE}, {EntityPainting.EnumArt.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {EnumCreatureAttribute.class}, {EnumCreatureType.class, Class.class, Integer.TYPE, Material.class, Boolean.TYPE, Boolean.TYPE}, {StructureStrongholdPieces.Stronghold.Door.class}, {EnumEnchantmentType.class, Predicate.class}, {BlockPressurePlate.Sensitivity.class}, {RayTraceResult.Type.class}, {EnumSkyBlock.class, Integer.TYPE}, {EntityPlayer.SleepResult.class}, {Item.ToolMaterial.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, {EnumRarity.class, TextFormatting.class, String.class}};

    @Nullable
    public static EnumAction addAction(String name) {
        return EnumHelper.addEnum(EnumAction.class, name, new Object[0]);
    }

    @Nullable
    public static ItemArmor.ArmorMaterial addArmorMaterial(String name, String textureName, int durability, int[] reductionAmounts, int enchantability, SoundEvent soundOnEquip, float toughness) {
        return EnumHelper.addEnum(ItemArmor.ArmorMaterial.class, name, textureName, durability, reductionAmounts, enchantability, soundOnEquip, Float.valueOf(toughness));
    }

    @Nullable
    public static EntityPainting.EnumArt addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHelper.addEnum(EntityPainting.EnumArt.class, name, tile, sizeX, sizeY, offsetX, offsetY);
    }

    @Nullable
    public static EnumCreatureAttribute addCreatureAttribute(String name) {
        return EnumHelper.addEnum(EnumCreatureAttribute.class, name, new Object[0]);
    }

    @Nullable
    public static EnumCreatureType addCreatureType(String name, Class<?> typeClass, int maxNumber, Material material, boolean peaceful, boolean animal) {
        return EnumHelper.addEnum(EnumCreatureType.class, name, typeClass, maxNumber, material, peaceful, animal);
    }

    @Nullable
    public static StructureStrongholdPieces.Stronghold.Door addDoor(String name) {
        return EnumHelper.addEnum(StructureStrongholdPieces.Stronghold.Door.class, name, new Object[0]);
    }

    @Nullable
    public static EnumEnchantmentType addEnchantmentType(String name, Predicate<Item> delegate) {
        return EnumHelper.addEnum(EnumEnchantmentType.class, name, delegate);
    }

    @Nullable
    public static BlockPressurePlate.Sensitivity addSensitivity(String name) {
        return EnumHelper.addEnum(BlockPressurePlate.Sensitivity.class, name, new Object[0]);
    }

    @Nullable
    public static RayTraceResult.Type addMovingObjectType(String name) {
        return EnumHelper.addEnum(RayTraceResult.Type.class, name, new Object[0]);
    }

    @Nullable
    public static EnumSkyBlock addSkyBlock(String name, int lightValue) {
        return EnumHelper.addEnum(EnumSkyBlock.class, name, lightValue);
    }

    @Nullable
    public static EntityPlayer.SleepResult addStatus(String name) {
        return EnumHelper.addEnum(EntityPlayer.SleepResult.class, name, new Object[0]);
    }

    @Nullable
    public static Item.ToolMaterial addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        return EnumHelper.addEnum(Item.ToolMaterial.class, name, harvestLevel, maxUses, Float.valueOf(efficiency), Float.valueOf(damage), enchantability);
    }

    @Nullable
    public static EnumRarity addRarity(String name, TextFormatting color, String displayName) {
        return EnumHelper.addEnum(EnumRarity.class, name, new Object[]{color, displayName});
    }

    private static void setup() {
        if (isSetup) {
            return;
        }
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        isSetup = true;
    }

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return newConstructorAccessor.invoke(reflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, @Nullable String value, int ordinal, Class<?>[] additionalTypes, @Nullable Object[] additionalValues) throws Exception {
        int additionalParamsCount = additionalValues == null ? 0 : additionalValues.length;
        Object[] params = new Object[additionalParamsCount + 2];
        params[0] = value;
        params[1] = ordinal;
        if (additionalValues != null) {
            System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        }
        return (T)((Enum)enumClass.cast(newInstance.invoke(EnumHelper.getConstructorAccessor(enumClass, additionalTypes), new Object[]{params})));
    }

    public static void setFailsafeFieldValue(Field field, @Nullable Object target, @Nullable Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
        fieldAccessorSet.invoke(fieldAccessor, target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Exception {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Exception {
        EnumHelper.blankField(enumClass, "enumConstantDirectory");
        EnumHelper.blankField(enumClass, "enumConstants");
    }

    @Nullable
    private static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Object ... paramValues) {
        EnumHelper.setup();
        return EnumHelper.addEnum(commonTypes, enumType, enumName, paramValues);
    }

    @Nullable
    protected static <T extends Enum<?>> T addEnum(Class<?>[][] map, Class<T> enumType, String enumName, Object ... paramValues) {
        for (Class<?>[] lookup : map) {
            if (lookup[0] != enumType) continue;
            Class[] paramTypes = new Class[lookup.length - 1];
            if (paramTypes.length > 0) {
                System.arraycopy(lookup, 1, paramTypes, 0, paramTypes.length);
            }
            return EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
        }
        return null;
    }

    public static void testEnum(Class<? extends Enum<?>> enumType, Class<?>[] paramTypes) {
        EnumHelper.addEnum(true, enumType, null, paramTypes, null);
    }

    @Nullable
    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        return EnumHelper.addEnum(false, enumType, enumName, paramTypes, paramValues);
    }

    @Nullable
    private static <T extends Enum<?>> T addEnum(boolean test, final Class<T> enumType, @Nullable String enumName, final Class<?>[] paramTypes, @Nullable Object[] paramValues) {
        Field[] fields;
        if (!isSetup) {
            EnumHelper.setup();
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = (FMLForgePlugin.RUNTIME_DEOBF ? 1 : 2) | 8 | 0x10 | 0x1000;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            final ArrayList lines = Lists.newArrayList();
            lines.add(String.format("Could not find $VALUES field for enum: %s", enumType.getName()));
            lines.add(String.format("Runtime Deobf: %s", FMLForgePlugin.RUNTIME_DEOBF));
            lines.add(String.format("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0')));
            lines.add("Fields:");
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                lines.add(String.format("       %s %s: %s", mods, field.getName(), field.getType().getName()));
            }
            for (String line : lines) {
                FMLLog.severe(line, new Object[0]);
            }
            if (test) {
                throw new EnhancedRuntimeException("Could not find $VALUES field for enum: " + enumType.getName()){

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        for (String line : lines) {
                            stream.println(line);
                        }
                    }
                };
            }
            return null;
        }
        if (test) {
            Object ctr = null;
            Exception ex = null;
            try {
                ctr = EnumHelper.getConstructorAccessor(enumType, paramTypes);
            }
            catch (Exception e) {
                ex = e;
            }
            if (ctr == null || ex != null) {
                throw new EnhancedRuntimeException(String.format("Could not find constructor for Enum %s", enumType.getName()), (Throwable)ex){

                    private String toString(Class<?>[] cls) {
                        StringBuilder b = new StringBuilder();
                        for (int x = 0; x < cls.length; ++x) {
                            b.append(cls[x].getName());
                            if (x == cls.length - 1) continue;
                            b.append(", ");
                        }
                        return b.toString();
                    }

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Target Arguments:");
                        stream.println("    java.lang.String, int, " + this.toString(paramTypes));
                        stream.println("Found Constructors:");
                        for (Constructor<?> ctr : enumType.getDeclaredConstructors()) {
                            stream.println("    " + this.toString(ctr.getParameterTypes()));
                        }
                    }
                };
            }
            return null;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            T newValue = EnumHelper.makeEnum(enumType, enumName, values.size(), paramTypes, paramValues);
            values.add((Enum)newValue);
            EnumHelper.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        if (!isSetup) {
            EnumHelper.setup();
        }
    }
}

