/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.GenericEvent;

public class AttachCapabilitiesEvent<T>
extends GenericEvent<T> {
    private final T obj;
    private final Map<ResourceLocation, ICapabilityProvider> caps = Maps.newLinkedHashMap();
    private final Map<ResourceLocation, ICapabilityProvider> view = Collections.unmodifiableMap(this.caps);

    @Deprecated
    public AttachCapabilitiesEvent(T obj) {
        this(Object.class, obj);
    }

    public AttachCapabilitiesEvent(Class<T> type, T obj) {
        super(type);
        this.obj = obj;
    }

    public T getObject() {
        return this.obj;
    }

    public void addCapability(ResourceLocation key, ICapabilityProvider cap) {
        if (this.caps.containsKey(key)) {
            throw new IllegalStateException("Duplicate Capability Key: " + key + " " + cap);
        }
        this.caps.put(key, cap);
    }

    public Map<ResourceLocation, ICapabilityProvider> getCapabilities() {
        return this.view;
    }

    @Deprecated
    public static class World
    extends AttachCapabilitiesEvent<net.minecraft.world.World> {
        private final net.minecraft.world.World world;

        public World(net.minecraft.world.World world) {
            super(net.minecraft.world.World.class, world);
            this.world = world;
        }

        public net.minecraft.world.World getWorld() {
            return this.world;
        }
    }

    public static class Item
    extends AttachCapabilitiesEvent<net.minecraft.item.Item> {
        private final ItemStack stack;
        @Deprecated
        private final net.minecraft.item.Item item;

        public Item(net.minecraft.item.Item item, @Nonnull ItemStack stack) {
            super(net.minecraft.item.Item.class, item);
            this.item = item;
            this.stack = stack;
        }

        @Deprecated
        public net.minecraft.item.Item getItem() {
            return this.item;
        }

        @Nonnull
        public ItemStack getItemStack() {
            return this.stack;
        }
    }

    @Deprecated
    public static class Entity
    extends AttachCapabilitiesEvent<net.minecraft.entity.Entity> {
        private final net.minecraft.entity.Entity entity;

        public Entity(net.minecraft.entity.Entity entity) {
            super(net.minecraft.entity.Entity.class, entity);
            this.entity = entity;
        }

        public net.minecraft.entity.Entity getEntity() {
            return this.entity;
        }
    }

    @Deprecated
    public static class TileEntity
    extends AttachCapabilitiesEvent<net.minecraft.tileentity.TileEntity> {
        private final net.minecraft.tileentity.TileEntity te;

        public TileEntity(net.minecraft.tileentity.TileEntity te) {
            super(net.minecraft.tileentity.TileEntity.class, te);
            this.te = te;
        }

        public net.minecraft.tileentity.TileEntity getTileEntity() {
            return this.te;
        }
    }
}

