/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntitySelectorEvent
extends Event {
    private final Map<String, String> map;
    private final String mainSelector;
    private final ICommandSender sender;
    private final Vec3d position;
    private final List<Predicate<Entity>> selectors;

    public EntitySelectorEvent(Map<String, String> map, String mainSelector, ICommandSender sender, Vec3d position) {
        this.map = map;
        this.mainSelector = mainSelector;
        this.sender = sender;
        this.position = position;
        this.selectors = Lists.newArrayList();
    }

    public void addPredicate(Predicate<Entity> selector) {
        if (selector == null) {
            throw new NullPointerException("Attempted to add null predicate as entity selector");
        }
        this.selectors.add(selector);
    }

    public String getMainSelector() {
        return this.mainSelector;
    }

    public Map<String, String> getArgumentMap() {
        return this.map;
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public ICommandSender getSender() {
        return this.sender;
    }

    List<Predicate<Entity>> getSelectors() {
        return this.selectors;
    }
}

