/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LivingSpawnEvent
extends LivingEvent {
    private final World world;
    private final float x;
    private final float y;
    private final float z;

    public LivingSpawnEvent(EntityLiving entity, World world, float x, float y, float z) {
        super(entity);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public World getWorld() {
        return this.world;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    @Event.HasResult
    public static class AllowDespawn
    extends LivingSpawnEvent {
        public AllowDespawn(EntityLiving entity) {
            super(entity, entity.world, (float)entity.posX, (float)entity.posY, (float)entity.posZ);
        }
    }

    @Cancelable
    public static class SpecialSpawn
    extends LivingSpawnEvent {
        public SpecialSpawn(EntityLiving entity, World world, float x, float y, float z) {
            super(entity, world, x, y, z);
        }
    }

    @Event.HasResult
    public static class CheckSpawn
    extends LivingSpawnEvent {
        public CheckSpawn(EntityLiving entity, World world, float x, float y, float z) {
            super(entity, world, x, y, z);
        }
    }
}

