/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.terraingen;

import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WorldTypeEvent
extends Event {
    private final WorldType worldType;

    public WorldTypeEvent(WorldType worldType) {
        this.worldType = worldType;
    }

    public WorldType getWorldType() {
        return this.worldType;
    }

    public static class InitBiomeGens
    extends WorldTypeEvent {
        private final long seed;
        private final GenLayer[] originalBiomeGens;
        private GenLayer[] newBiomeGens;

        public InitBiomeGens(WorldType worldType, long seed, GenLayer[] original) {
            super(worldType);
            this.seed = seed;
            this.originalBiomeGens = original;
            this.setNewBiomeGens((GenLayer[])original.clone());
        }

        public long getSeed() {
            return this.seed;
        }

        public GenLayer[] getOriginalBiomeGens() {
            return this.originalBiomeGens;
        }

        public GenLayer[] getNewBiomeGens() {
            return this.newBiomeGens;
        }

        public void setNewBiomeGens(GenLayer[] newBiomeGens) {
            this.newBiomeGens = newBiomeGens;
        }
    }

    public static class BiomeSize
    extends WorldTypeEvent {
        private final int originalSize;
        private int newSize;

        public BiomeSize(WorldType worldType, int original) {
            super(worldType);
            this.originalSize = original;
            this.setNewSize(original);
        }

        public int getOriginalSize() {
            return this.originalSize;
        }

        public int getNewSize() {
            return this.newSize;
        }

        public void setNewSize(int newSize) {
            this.newSize = newSize;
        }
    }
}

