/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends Block
implements IFluidBlock {
    protected static final Map<Block, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<Block, Boolean> displacements = Maps.newHashMap();
    public static final PropertyInteger LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final ImmutableList<IUnlistedProperty<Float>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected BlockRenderLayer renderLayer = BlockRenderLayer.TRANSLUCENT;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, Material material) {
        super(material);
        this.setTickRandomly(true);
        this.disableStats();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.setDefaultState(this.blockState.getBaseState().withProperty(LEVEL, 0));
    }

    @Override
    @Nonnull
    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LEVEL}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    @Override
    public int getMetaFromState(@Nonnull IBlockState state) {
        return state.getValue(LEVEL);
    }

    @Override
    @Deprecated
    @Nonnull
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(LEVEL, meta);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(BlockRenderLayer renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.isAirBlock(pos)) {
            return true;
        }
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == this) {
            return false;
        }
        if (this.displacements.containsKey(state.getBlock())) {
            return this.displacements.get(state.getBlock());
        }
        Material material = state.getMaterial();
        if (material.blocksMovement() || material == Material.PORTAL) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.isAirBlock(pos)) {
            return true;
        }
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                if (state.getBlock() != Blocks.SNOW_LAYER) {
                    block.dropBlockAsItem(world, pos, state, 0);
                }
                return true;
            }
            return false;
        }
        Material material = state.getMaterial();
        if (material.blocksMovement() || material == Material.PORTAL) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            block.dropBlockAsItem(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(IBlockAccess var1, BlockPos var2);

    @Override
    public abstract boolean canCollideCheck(@Nonnull IBlockState var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    @Override
    public void onBlockAdded(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        world.scheduleUpdate(pos, this, this.tickRate);
    }

    @Override
    public void neighborChanged(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighbourPos) {
        world.scheduleUpdate(pos, this, this.tickRate);
    }

    @Override
    public boolean requiresUpdates() {
        return false;
    }

    @Override
    public boolean isPassable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    @Override
    @Nonnull
    public Item getItemDropped(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Items.AIR;
    }

    @Override
    public int quantityDropped(@Nonnull Random par1Random) {
        return 0;
    }

    @Override
    public int tickRate(@Nonnull World world) {
        return this.tickRate;
    }

    @Override
    @Nonnull
    public Vec3d modifyAcceleration(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Entity entity, @Nonnull Vec3d vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        Vec3d vec_flow = this.getFlowVector(world, pos);
        return vec.addVector(vec_flow.xCoord * (double)(this.quantaPerBlock * 4), vec_flow.yCoord * (double)(this.quantaPerBlock * 4), vec_flow.zCoord * (double)(this.quantaPerBlock * 4));
    }

    @Override
    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = state.getValue(LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    @Override
    public boolean isOpaqueCube(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    public boolean isFullCube(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    public int getPackedLightmapCoords(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int lightThis = world.getCombinedLight(pos, 0);
        int lightUp = world.getCombinedLight(pos.up(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer getBlockLayer() {
        return this.renderLayer;
    }

    @Override
    public boolean shouldSideBeRendered(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IBlockState neighbor = world.getBlockState(pos.offset(side));
        if (neighbor.getMaterial() == state.getMaterial()) {
            return false;
        }
        if (this.densityDir == -1 && side == EnumFacing.UP) {
            return true;
        }
        if (this.densityDir == 1 && side == EnumFacing.DOWN) {
            return true;
        }
        return super.shouldSideBeRendered(state, world, pos, side);
    }

    @Override
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState oldState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(worldIn, pos)));
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        height[1][1] = this.getFluidHeightForRender(worldIn, pos);
        if (height[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            int j;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    height[i][j] = this.getFluidHeightForRender(worldIn, pos.add(i - 1, 0, j - 1));
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]);
                }
            }
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static final int getDensity(IBlockAccess world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(IBlockAccess world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (!state.getMaterial().isLiquid()) {
            return -1000.0;
        }
        Vec3d vec = ((BlockFluidBase)state.getBlock()).getFlowVector(world, pos);
        return vec.xCoord == 0.0 && vec.zCoord == 0.0 ? -1000.0 : Math.atan2(vec.zCoord, vec.xCoord) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(IBlockAccess world, BlockPos pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(IBlockAccess world, BlockPos pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(IBlockAccess world, BlockPos pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 0.875f) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(IBlockAccess world, BlockPos pos) {
        IBlockState here = world.getBlockState(pos);
        IBlockState up = world.getBlockState(pos.down(this.densityDir));
        if (here.getBlock() == this) {
            if (up.getMaterial().isLiquid() || up.getBlock() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.getMetaFromState(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.getBlock() instanceof BlockLiquid) {
            return Math.min(1.0f - BlockLiquid.getLiquidHeightPercent(here.getValue(BlockLiquid.LEVEL)), 0.875f);
        }
        return !here.getMaterial().isSolid() && up.getBlock() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public Vec3d getFlowVector(IBlockAccess world, BlockPos pos) {
        Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.getX();
            int z2 = pos.getZ();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            BlockPos pos2 = new BlockPos(x2, pos.getY(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.getBlockState(pos2).getMaterial().blocksMovement() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.down())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.addVector((pos2.getX() - pos.getX()) * power, 0.0, (pos2.getZ() - pos.getZ()) * power);
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.addVector((pos2.getX() - pos.getX()) * power, 0.0, (pos2.getZ() - pos.getZ()) * power);
        }
        if (world.getBlockState(pos.up()).getBlock() == this) {
            boolean flag;
            boolean bl = flag = this.isBlockSolid(world, pos.add(0, 0, -1), EnumFacing.NORTH) || this.isBlockSolid(world, pos.add(0, 0, 1), EnumFacing.SOUTH) || this.isBlockSolid(world, pos.add(-1, 0, 0), EnumFacing.WEST) || this.isBlockSolid(world, pos.add(1, 0, 0), EnumFacing.EAST) || this.isBlockSolid(world, pos.add(0, 1, -1), EnumFacing.NORTH) || this.isBlockSolid(world, pos.add(0, 1, 1), EnumFacing.SOUTH) || this.isBlockSolid(world, pos.add(-1, 1, 0), EnumFacing.WEST) || this.isBlockSolid(world, pos.add(1, 1, 0), EnumFacing.EAST);
            if (flag) {
                vec = vec.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec = vec.normalize();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(World world, BlockPos pos) {
        int quantaRemaining = this.getQuantaValue(world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBox(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return NULL_AABB;
    }

    static {
        defaultDisplacements.put(Blocks.OAK_DOOR, false);
        defaultDisplacements.put(Blocks.SPRUCE_DOOR, false);
        defaultDisplacements.put(Blocks.BIRCH_DOOR, false);
        defaultDisplacements.put(Blocks.JUNGLE_DOOR, false);
        defaultDisplacements.put(Blocks.ACACIA_DOOR, false);
        defaultDisplacements.put(Blocks.DARK_OAK_DOOR, false);
        defaultDisplacements.put(Blocks.TRAPDOOR, false);
        defaultDisplacements.put(Blocks.IRON_TRAPDOOR, false);
        defaultDisplacements.put(Blocks.OAK_FENCE, false);
        defaultDisplacements.put(Blocks.SPRUCE_FENCE, false);
        defaultDisplacements.put(Blocks.BIRCH_FENCE, false);
        defaultDisplacements.put(Blocks.JUNGLE_FENCE, false);
        defaultDisplacements.put(Blocks.DARK_OAK_FENCE, false);
        defaultDisplacements.put(Blocks.ACACIA_FENCE, false);
        defaultDisplacements.put(Blocks.NETHER_BRICK_FENCE, false);
        defaultDisplacements.put(Blocks.OAK_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.SPRUCE_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.BIRCH_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.JUNGLE_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.DARK_OAK_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.ACACIA_FENCE_GATE, false);
        defaultDisplacements.put(Blocks.WOODEN_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.STONE_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, false);
        defaultDisplacements.put(Blocks.LADDER, false);
        defaultDisplacements.put(Blocks.IRON_BARS, false);
        defaultDisplacements.put(Blocks.GLASS_PANE, false);
        defaultDisplacements.put(Blocks.STAINED_GLASS_PANE, false);
        defaultDisplacements.put(Blocks.PORTAL, false);
        defaultDisplacements.put(Blocks.END_PORTAL, false);
        defaultDisplacements.put(Blocks.COBBLESTONE_WALL, false);
        defaultDisplacements.put(Blocks.BARRIER, false);
        defaultDisplacements.put(Blocks.STANDING_BANNER, false);
        defaultDisplacements.put(Blocks.WALL_BANNER, false);
        defaultDisplacements.put(Blocks.CAKE, false);
        defaultDisplacements.put(Blocks.IRON_DOOR, false);
        defaultDisplacements.put(Blocks.STANDING_SIGN, false);
        defaultDisplacements.put(Blocks.WALL_SIGN, false);
        defaultDisplacements.put(Blocks.REEDS, false);
        LEVEL = PropertyInteger.create("level", 0, 15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i = 0; i < 4; ++i) {
            BlockFluidBase.LEVEL_CORNERS[i] = new PropertyFloat("level_corner_" + i);
            builder.add((Object)LEVEL_CORNERS[i]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }
}

